/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.stream.binder.BinderFactory;
import org.springframework.cloud.stream.binding.AbstractBindingTargetFactory;
import org.springframework.cloud.stream.binding.BinderAwareChannelResolver;
import org.springframework.cloud.stream.binding.BinderAwareRouterBeanPostProcessor;
import org.springframework.cloud.stream.binding.BindingService;
import org.springframework.cloud.stream.binding.CompositeMessageChannelConfigurer;
import org.springframework.cloud.stream.binding.ContextStartAfterRefreshListener;
import org.springframework.cloud.stream.binding.DynamicDestinationsBindable;
import org.springframework.cloud.stream.binding.InputBindingLifecycle;
import org.springframework.cloud.stream.binding.MessageChannelConfigurer;
import org.springframework.cloud.stream.binding.MessageConverterConfigurer;
import org.springframework.cloud.stream.binding.OutputBindingLifecycle;
import org.springframework.cloud.stream.binding.SingleBindingTargetBindable;
import org.springframework.cloud.stream.binding.StreamListenerAnnotationBeanPostProcessor;
import org.springframework.cloud.stream.binding.SubscribableChannelBindingTargetFactory;
import org.springframework.cloud.stream.config.BindingServiceProperties;
import org.springframework.cloud.stream.config.ChannelBindingServiceProperties;
import org.springframework.cloud.stream.config.SpringIntegrationProperties;
import org.springframework.cloud.stream.converter.CompositeMessageConverterFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.integration.channel.DirectChannel;
import org.springframework.integration.channel.PublishSubscribeChannel;
import org.springframework.integration.config.IntegrationEvaluationContextFactoryBean;
import org.springframework.integration.handler.AbstractReplyProducingMessageHandler;
import org.springframework.integration.handler.BridgeHandler;
import org.springframework.integration.json.JsonPropertyAccessor;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.MessageHandler;
import org.springframework.messaging.converter.MessageConverter;
import org.springframework.messaging.core.DestinationResolutionException;
import org.springframework.messaging.core.DestinationResolver;
import org.springframework.messaging.handler.annotation.support.DefaultMessageHandlerMethodFactory;
import org.springframework.messaging.handler.annotation.support.MessageHandlerMethodFactory;
import org.springframework.tuple.spel.TuplePropertyAccessor;
import org.springframework.util.CollectionUtils;

@Configuration
@EnableConfigurationProperties(value={BindingServiceProperties.class, SpringIntegrationProperties.class})
public class BindingServiceConfiguration {
    public static final String STREAM_LISTENER_ANNOTATION_BEAN_POST_PROCESSOR_NAME = "streamListenerAnnotationBeanPostProcessor";
    public static final String ERROR_BRIDGE_CHANNEL = "errorBridgeChannel";
    private static final String ERROR_KEY_NAME = "error";
    @Autowired(required=false)
    private ObjectMapper objectMapper;
    @Autowired(required=false)
    private List<MessageConverter> customMessageConverters;

    @Bean
    public static MessageHandlerMethodFactory messageHandlerMethodFactory(CompositeMessageConverterFactory compositeMessageConverterFactory) {
        DefaultMessageHandlerMethodFactory messageHandlerMethodFactory = new DefaultMessageHandlerMethodFactory();
        messageHandlerMethodFactory.setMessageConverter((MessageConverter)compositeMessageConverterFactory.getMessageConverterForAllRegistered());
        return messageHandlerMethodFactory;
    }

    @Bean(name={"streamListenerAnnotationBeanPostProcessor"})
    public static StreamListenerAnnotationBeanPostProcessor streamListenerAnnotationBeanPostProcessor() {
        return new StreamListenerAnnotationBeanPostProcessor();
    }

    @Bean
    @ConditionalOnMissingBean(value={BindingService.class})
    public BindingService bindingService(BindingServiceProperties bindingServiceProperties, BinderFactory binderFactory) {
        return new BindingService(bindingServiceProperties, binderFactory);
    }

    @Bean
    public MessageConverterConfigurer messageConverterConfigurer(BindingServiceProperties bindingServiceProperties, CompositeMessageConverterFactory compositeMessageConverterFactory) {
        return new MessageConverterConfigurer(bindingServiceProperties, compositeMessageConverterFactory);
    }

    @Bean
    public SubscribableChannelBindingTargetFactory channelFactory(CompositeMessageChannelConfigurer compositeMessageChannelConfigurer) {
        return new SubscribableChannelBindingTargetFactory(compositeMessageChannelConfigurer);
    }

    @Bean
    public CompositeMessageChannelConfigurer compositeMessageChannelConfigurer(MessageConverterConfigurer messageConverterConfigurer) {
        ArrayList<MessageChannelConfigurer> configurerList = new ArrayList<MessageChannelConfigurer>();
        configurerList.add(messageConverterConfigurer);
        return new CompositeMessageChannelConfigurer(configurerList);
    }

    @Bean
    @DependsOn(value={"bindingService"})
    public OutputBindingLifecycle outputBindingLifecycle() {
        return new OutputBindingLifecycle();
    }

    @Bean
    @DependsOn(value={"bindingService"})
    public InputBindingLifecycle inputBindingLifecycle() {
        return new InputBindingLifecycle();
    }

    @Bean
    @DependsOn(value={"bindingService"})
    public ContextStartAfterRefreshListener contextStartAfterRefreshListener() {
        return new ContextStartAfterRefreshListener();
    }

    @Bean
    public BinderAwareChannelResolver binderAwareChannelResolver(BindingService bindingService, AbstractBindingTargetFactory<? extends MessageChannel> bindingTargetFactory, DynamicDestinationsBindable dynamicDestinationsBindable) {
        return new BinderAwareChannelResolver(bindingService, bindingTargetFactory, dynamicDestinationsBindable);
    }

    @Bean
    @ConditionalOnProperty(value={"spring.cloud.stream.bindings.error.destination"})
    public MessageChannel errorBridgeChannel(@Qualifier(value="errorChannel") PublishSubscribeChannel errorChannel) {
        DirectChannel errorBridgeChannel = new DirectChannel();
        BridgeHandler handler = new BridgeHandler();
        handler.setOutputChannel((MessageChannel)errorBridgeChannel);
        errorChannel.subscribe((MessageHandler)handler);
        return errorBridgeChannel;
    }

    @Bean
    @ConditionalOnProperty(value={"spring.cloud.stream.bindings.error.destination"})
    public SingleBindingTargetBindable<MessageChannel> errorBridgeChannelBindable(@Qualifier(value="errorBridgeChannel") MessageChannel errorBridgeChannel, CompositeMessageChannelConfigurer compositeMessageChannelConfigurer) {
        compositeMessageChannelConfigurer.configureOutputChannel(errorBridgeChannel, ERROR_KEY_NAME);
        return new SingleBindingTargetBindable<MessageChannel>(ERROR_KEY_NAME, errorBridgeChannel);
    }

    @Bean
    public DynamicDestinationsBindable dynamicDestinationsBindable() {
        return new DynamicDestinationsBindable();
    }

    @Bean
    public CompositeMessageConverterFactory compositeMessageConverterFactory() {
        ArrayList<MessageConverter> messageConverters = new ArrayList<MessageConverter>();
        if (!CollectionUtils.isEmpty(this.customMessageConverters)) {
            messageConverters.addAll(Collections.unmodifiableCollection(this.customMessageConverters));
        }
        return new CompositeMessageConverterFactory(messageConverters, this.objectMapper);
    }

    @Bean
    public ChannelBindingServiceProperties channelBindingServiceProperties(BindingServiceProperties bindingServiceProperties) {
        return new ChannelBindingServiceProperties(bindingServiceProperties);
    }

    @Configuration
    protected static class PostProcessorConfiguration {
        private BinderAwareChannelResolver binderAwareChannelResolver;

        protected PostProcessorConfiguration() {
        }

        @Bean
        public static BeanPostProcessor propertyAccessorBeanPostProcessor() {
            final HashMap<String, Object> accessors = new HashMap<String, Object>();
            accessors.put("tuplePropertyAccessor", new TuplePropertyAccessor());
            accessors.put("jsonPropertyAccessor", new JsonPropertyAccessor());
            return new BeanPostProcessor(){

                public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
                    if ("integrationEvaluationContext".equals(beanName)) {
                        IntegrationEvaluationContextFactoryBean factoryBean = (IntegrationEvaluationContextFactoryBean)bean;
                        Map factoryBeanAccessors = factoryBean.getPropertyAccessors();
                        for (Map.Entry entry : accessors.entrySet()) {
                            if (factoryBeanAccessors.containsKey(entry.getKey())) continue;
                            factoryBeanAccessors.put(entry.getKey(), entry.getValue());
                        }
                        factoryBean.setPropertyAccessors(factoryBeanAccessors);
                    }
                    return bean;
                }

                public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
                    return bean;
                }
            };
        }

        @Bean
        @ConditionalOnMissingBean(value={BinderAwareRouterBeanPostProcessor.class})
        public BinderAwareRouterBeanPostProcessor binderAwareRouterBeanPostProcessor(final ConfigurableListableBeanFactory beanFactory) {
            return new BinderAwareRouterBeanPostProcessor(new DestinationResolver<MessageChannel>(){

                public MessageChannel resolveDestination(String name) throws DestinationResolutionException {
                    if (PostProcessorConfiguration.this.binderAwareChannelResolver == null) {
                        PostProcessorConfiguration.this.binderAwareChannelResolver = (BinderAwareChannelResolver)((Object)BeanFactoryUtils.beanOfType((ListableBeanFactory)beanFactory, BinderAwareChannelResolver.class));
                    }
                    return PostProcessorConfiguration.this.binderAwareChannelResolver.resolveDestination(name);
                }
            });
        }

        @Bean
        public static BeanPostProcessor messageHandlerHeaderPropagationBeanPostProcessor(final SpringIntegrationProperties springIntegrationProperties) {
            return new BeanPostProcessor(){

                public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
                    Class<?> beanClass;
                    Class<?> clazz = beanClass = AopUtils.isAopProxy((Object)bean) ? AopUtils.getTargetClass((Object)bean) : bean.getClass();
                    if (AbstractReplyProducingMessageHandler.class.isAssignableFrom(beanClass)) {
                        AbstractReplyProducingMessageHandler messageHandler = (AbstractReplyProducingMessageHandler)bean;
                        messageHandler.addNotPropagatedHeaders(springIntegrationProperties.getMessageHandlerNotPropagatedHeaders());
                    }
                    return bean;
                }

                public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
                    return bean;
                }
            };
        }
    }
}

