/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.zipkin2.sender;

import org.springframework.boot.autoconfigure.condition.ConditionMessage;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.boot.bind.RelaxedPropertyResolver;
import org.springframework.cloud.sleuth.zipkin2.sender.ZipkinSenderConfigurationImportSelector;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.env.PropertyResolver;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.core.type.ClassMetadata;

class ZipkinSenderCondition
extends SpringBootCondition {
    ZipkinSenderCondition() {
    }

    public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata md) {
        String sourceClass = "";
        if (md instanceof ClassMetadata) {
            sourceClass = ((ClassMetadata)md).getClassName();
        }
        ConditionMessage.Builder message = ConditionMessage.forCondition((String)"ZipkinSender", (Object[])new Object[]{sourceClass});
        RelaxedPropertyResolver resolver = new RelaxedPropertyResolver((PropertyResolver)context.getEnvironment(), "spring.zipkin.sender.");
        if (!resolver.containsProperty("type")) {
            return ConditionOutcome.match((ConditionMessage)message.because("automatic sender type"));
        }
        String senderType = ZipkinSenderConfigurationImportSelector.getType(((AnnotationMetadata)md).getClassName());
        String value = resolver.getProperty("type");
        if (value.equals(senderType)) {
            return ConditionOutcome.match((ConditionMessage)message.because(value + " sender type"));
        }
        return ConditionOutcome.noMatch((ConditionMessage)message.because(value + " sender type"));
    }
}

