/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.zipkin2;

import java.lang.invoke.MethodHandles;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.boot.bind.RelaxedPropertyResolver;
import org.springframework.boot.context.embedded.EmbeddedServletContainerInitializedEvent;
import org.springframework.cloud.client.serviceregistry.Registration;
import org.springframework.cloud.commons.util.InetUtils;
import org.springframework.cloud.commons.util.InetUtilsProperties;
import org.springframework.cloud.sleuth.zipkin2.EndpointLocator;
import org.springframework.cloud.sleuth.zipkin2.ZipkinProperties;
import org.springframework.context.event.EventListener;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertyResolver;
import org.springframework.util.StringUtils;
import zipkin2.Endpoint;

public class DefaultEndpointLocator
implements EndpointLocator {
    private static final Log log = LogFactory.getLog(MethodHandles.lookup().lookupClass());
    private static final String IP_ADDRESS_PROP_NAME = "spring.cloud.client.ipAddress";
    private final Registration registration;
    private final ServerProperties serverProperties;
    private final InetUtils inetUtils;
    private final ZipkinProperties zipkinProperties;
    private final RelaxedPropertyResolver resolver;
    private Integer port;

    public DefaultEndpointLocator(Registration registration, ServerProperties serverProperties, Environment environment, ZipkinProperties zipkinProperties, InetUtils inetUtils) {
        this.registration = registration;
        this.serverProperties = serverProperties;
        this.zipkinProperties = zipkinProperties;
        this.inetUtils = inetUtils == null ? new InetUtils(new InetUtilsProperties()) : inetUtils;
        this.resolver = new RelaxedPropertyResolver((PropertyResolver)environment);
    }

    @Override
    public Endpoint local() {
        String serviceName = this.getLocalServiceName();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Span will contain serviceName [" + serviceName + "]"));
        }
        Endpoint.Builder builder = Endpoint.newBuilder().serviceName(serviceName).port(this.getPort());
        return this.addAddress(builder).build();
    }

    private String getLocalServiceName() {
        if (StringUtils.hasText((String)this.zipkinProperties.getService().getName())) {
            return this.zipkinProperties.getService().getName();
        }
        if (this.registration != null) {
            try {
                return this.registration.getServiceId();
            }
            catch (RuntimeException e) {
                log.warn((Object)"error getting service name from registration", (Throwable)e);
            }
        }
        return this.resolver.getProperty("spring.application.name", "unknown");
    }

    @EventListener(value={EmbeddedServletContainerInitializedEvent.class})
    public void grabPort(EmbeddedServletContainerInitializedEvent event) {
        this.port = event.getEmbeddedServletContainer().getPort();
    }

    private Integer getPort() {
        if (this.port != null) {
            return this.port;
        }
        Integer port = this.serverProperties != null && this.serverProperties.getPort() != null && this.serverProperties.getPort() > 0 ? this.serverProperties.getPort() : Integer.valueOf(8080);
        return port;
    }

    private Endpoint.Builder addAddress(Endpoint.Builder builder) {
        if (this.serverProperties != null && this.serverProperties.getAddress() != null && builder.parseIp(this.serverProperties.getAddress())) {
            return builder;
        }
        if (this.resolver.containsProperty(IP_ADDRESS_PROP_NAME) && builder.parseIp((String)this.resolver.getProperty(IP_ADDRESS_PROP_NAME, String.class))) {
            return builder;
        }
        return builder.ip(this.inetUtils.findFirstNonLoopbackAddress());
    }
}

