/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.web.mvc;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.sleuth.SpanCustomizer;
import org.springframework.cloud.sleuth.instrument.web.mvc.HandlerParser;
import org.springframework.lang.Nullable;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

public final class SpanCustomizingHandlerInterceptor
implements HandlerInterceptor {
    static final String BEST_MATCHING_PATTERN_ATTRIBUTE = "org.springframework.web.servlet.HandlerMapping.bestMatchingPattern";
    @Autowired(required=false)
    HandlerParser handlerParser = new HandlerParser();

    SpanCustomizingHandlerInterceptor() {
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object o) {
        Object span = request.getAttribute(SpanCustomizer.class.getName());
        if (span instanceof SpanCustomizer) {
            SpanCustomizingHandlerInterceptor.setHttpRouteAttribute(request);
            this.handlerParser.preHandle(request, o, (SpanCustomizer)span);
        }
        return true;
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) {
        Object span = request.getAttribute(SpanCustomizer.class.getName());
        if (span instanceof SpanCustomizer) {
            this.handlerParser.postHandle(request, handler, modelAndView, (SpanCustomizer)span);
        }
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) {
        Object span = request.getAttribute(SpanCustomizer.class.getName());
        if (span instanceof SpanCustomizer) {
            SpanCustomizingHandlerInterceptor.setErrorAttribute(request, ex);
        }
    }

    static void setErrorAttribute(HttpServletRequest request, @Nullable Exception ex) {
        if (ex != null && request.getAttribute("error") == null) {
            request.setAttribute("error", (Object)ex);
        }
    }

    static void setHttpRouteAttribute(HttpServletRequest request) {
        Object httpRoute = request.getAttribute(BEST_MATCHING_PATTERN_ATTRIBUTE);
        request.setAttribute("http.route", (Object)(httpRoute != null ? httpRoute.toString() : ""));
    }
}

