/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.session;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.cloud.sleuth.CurrentTraceContext;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.cloud.sleuth.instrument.session.TraceFindByIndexNameSessionRepository;
import org.springframework.cloud.sleuth.instrument.session.TraceReactiveSessionRepository;
import org.springframework.cloud.sleuth.instrument.session.TraceSessionRepository;
import org.springframework.session.FindByIndexNameSessionRepository;
import org.springframework.session.ReactiveSessionRepository;
import org.springframework.session.SessionRepository;
import org.springframework.util.ReflectionUtils;

@Aspect
public class TraceSessionRepositoryAspect {
    private static final Log log = LogFactory.getLog(TraceSessionRepositoryAspect.class);
    private final Tracer tracer;
    private final CurrentTraceContext currentTraceContext;

    public TraceSessionRepositoryAspect(Tracer tracer, CurrentTraceContext currentTraceContext) {
        this.tracer = tracer;
        this.currentTraceContext = currentTraceContext;
    }

    @Around(value="execution(public * org.springframework.session.SessionRepository.*(..))")
    public Object wrapSessionRepository(ProceedingJoinPoint pjp) throws Throwable {
        SessionRepository target = (SessionRepository)pjp.getTarget();
        if (target instanceof TraceSessionRepository) {
            return pjp.proceed();
        }
        target = this.wrapSessionRepository(target);
        return this.callMethodOnWrappedObject(pjp, target);
    }

    private SessionRepository wrapSessionRepository(SessionRepository target) {
        if (target instanceof FindByIndexNameSessionRepository) {
            return new TraceFindByIndexNameSessionRepository(this.tracer, (FindByIndexNameSessionRepository)target);
        }
        return new TraceSessionRepository(this.tracer, target);
    }

    private <T> Object callMethodOnWrappedObject(ProceedingJoinPoint pjp, T target) throws Throwable {
        Method method = this.getMethod(pjp, target);
        if (method != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Found a corresponding method on the trace representation [" + method + "]"));
            }
            return ReflectionUtils.invokeMethod((Method)method, target, (Object[])pjp.getArgs());
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Method [" + pjp.getSignature().getName() + "] not found on the trace representation. Will run the original one."));
        }
        return pjp.proceed();
    }

    @Around(value="execution(public * org.springframework.session.ReactiveSessionRepository.*(..))")
    public Object wrapReactiveSessionRepository(ProceedingJoinPoint pjp) throws Throwable {
        ReactiveSessionRepository target = (ReactiveSessionRepository)pjp.getTarget();
        if (target instanceof TraceReactiveSessionRepository) {
            return pjp.proceed();
        }
        target = new TraceReactiveSessionRepository(this.tracer, this.currentTraceContext, target);
        return this.callMethodOnWrappedObject(pjp, target);
    }

    Method getMethod(ProceedingJoinPoint pjp, Object tracingWrapper) {
        MethodSignature signature = (MethodSignature)pjp.getSignature();
        Method method = signature.getMethod();
        Method foundMethodOnTracingWrapper = ReflectionUtils.findMethod(tracingWrapper.getClass(), (String)method.getName(), (Class[])method.getParameterTypes());
        if (foundMethodOnTracingWrapper != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Found an exact match for method execution [" + foundMethodOnTracingWrapper + "]"));
            }
            return foundMethodOnTracingWrapper;
        }
        Object[] uniquePublicDeclaredMethodsOnTracingWrapper = ReflectionUtils.getUniqueDeclaredMethods(tracingWrapper.getClass(), m -> Modifier.isPublic(m.getModifiers()));
        if (uniquePublicDeclaredMethodsOnTracingWrapper.length == 0) {
            return null;
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("Will pick one of the unique declared methods [" + Arrays.toString(uniquePublicDeclaredMethodsOnTracingWrapper) + "] that has a name [" + method.getName() + "]"));
        }
        Object[] argsOnOriginalObject = pjp.getArgs();
        return Arrays.stream(uniquePublicDeclaredMethodsOnTracingWrapper).filter(m -> m.getName().equals(method.getName()) && this.paramsAreOfSameTyperInherited(argsOnOriginalObject, m.getParameterTypes())).findFirst().orElse(null);
    }

    private boolean paramsAreOfSameTyperInherited(Object[] argsOnOriginalObject, Class<?>[] typeOnTracingWrapper) {
        if (argsOnOriginalObject.length != typeOnTracingWrapper.length) {
            return false;
        }
        for (int i = 0; i < argsOnOriginalObject.length; ++i) {
            Class<?> typeOnWrapper = typeOnTracingWrapper[i];
            Class<?> argType = argsOnOriginalObject[i].getClass();
            if (typeOnWrapper.isAssignableFrom(argType)) continue;
            return false;
        }
        return true;
    }
}

