/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.prometheus;

import io.prometheus.client.exemplars.tracer.common.SpanContextSupplier;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.SmartInitializingSingleton;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.cloud.sleuth.instrument.prometheus.SleuthSpanContextSupplier;

public class LazySleuthSpanContextSupplier
implements SpanContextSupplier,
SmartInitializingSingleton {
    private final ObjectProvider<Tracer> tracerProvider;
    private SpanContextSupplier delegate;

    public LazySleuthSpanContextSupplier(ObjectProvider<Tracer> tracerProvider) {
        this.tracerProvider = tracerProvider;
    }

    public String getTraceId() {
        return this.delegate != null ? this.delegate.getTraceId() : null;
    }

    public String getSpanId() {
        return this.delegate != null ? this.delegate.getSpanId() : null;
    }

    public void afterSingletonsInstantiated() {
        Tracer tracer = (Tracer)this.tracerProvider.getIfAvailable();
        if (tracer != null) {
            this.delegate = new SleuthSpanContextSupplier(tracer);
        }
    }
}

