/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.annotation;

import java.lang.reflect.Method;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.aop.IntroductionInterceptor;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.cloud.sleuth.annotation.ContinueSpan;
import org.springframework.cloud.sleuth.annotation.NewSpan;
import org.springframework.cloud.sleuth.annotation.SleuthMethodInvocationProcessor;
import org.springframework.cloud.sleuth.instrument.annotation.SleuthAnnotationUtils;

class SleuthInterceptor
implements IntroductionInterceptor,
BeanFactoryAware {
    private BeanFactory beanFactory;
    private SleuthMethodInvocationProcessor methodInvocationProcessor;

    SleuthInterceptor() {
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        Method method = invocation.getMethod();
        if (method == null) {
            return invocation.proceed();
        }
        Method mostSpecificMethod = AopUtils.getMostSpecificMethod((Method)method, invocation.getThis().getClass());
        NewSpan newSpan = SleuthAnnotationUtils.findAnnotation(mostSpecificMethod, NewSpan.class);
        ContinueSpan continueSpan = SleuthAnnotationUtils.findAnnotation(mostSpecificMethod, ContinueSpan.class);
        if (newSpan == null && continueSpan == null) {
            return invocation.proceed();
        }
        return this.methodInvocationProcessor().process(invocation, newSpan, continueSpan);
    }

    private SleuthMethodInvocationProcessor methodInvocationProcessor() {
        if (this.methodInvocationProcessor == null) {
            this.methodInvocationProcessor = (SleuthMethodInvocationProcessor)this.beanFactory.getBean(SleuthMethodInvocationProcessor.class);
        }
        return this.methodInvocationProcessor;
    }

    public boolean implementsInterface(Class<?> intf) {
        return true;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }
}

