/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.web.mvc;

import javax.servlet.http.HttpServletRequest;
import org.springframework.cloud.sleuth.SpanCustomizer;
import org.springframework.cloud.sleuth.instrument.web.mvc.WebMvcRuntime;
import org.springframework.web.method.HandlerMethod;

public class HandlerParser {
    public static final HandlerParser NOOP = new HandlerParser(){

        @Override
        protected void preHandle(HttpServletRequest request, Object handler, SpanCustomizer customizer) {
        }
    };
    public static final String CONTROLLER_CLASS = "mvc.controller.class";
    public static final String CONTROLLER_METHOD = "mvc.controller.method";

    protected void preHandle(HttpServletRequest request, Object handler, SpanCustomizer customizer) {
        if (WebMvcRuntime.get().isHandlerMethod(handler)) {
            HandlerMethod handlerMethod = (HandlerMethod)handler;
            customizer.tag(CONTROLLER_CLASS, handlerMethod.getBeanType().getSimpleName());
            customizer.tag(CONTROLLER_METHOD, handlerMethod.getMethod().getName());
        } else {
            customizer.tag(CONTROLLER_CLASS, handler.getClass().getSimpleName());
        }
    }
}

