/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.web.client;

import brave.Span;
import brave.http.HttpTracing;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.gateway.filter.headers.HttpHeadersFilter;
import org.springframework.cloud.sleuth.instrument.web.client.AbstractHttpHeadersFilter;
import org.springframework.http.HttpHeaders;
import org.springframework.util.MultiValueMap;
import org.springframework.web.server.ServerWebExchange;

final class TraceResponseHttpHeadersFilter
extends AbstractHttpHeadersFilter {
    private static final Log log = LogFactory.getLog(TraceResponseHttpHeadersFilter.class);

    private TraceResponseHttpHeadersFilter(HttpTracing httpTracing) {
        super(httpTracing);
    }

    static HttpHeadersFilter create(HttpTracing httpTracing) {
        return new TraceResponseHttpHeadersFilter(httpTracing);
    }

    public HttpHeaders filter(HttpHeaders input, ServerWebExchange exchange) {
        Object storedSpan = exchange.getAttribute(SPAN_ATTRIBUTE);
        if (storedSpan == null) {
            return input;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Will instrument the response");
        }
        AbstractHttpHeadersFilter.HttpClientResponse response = new AbstractHttpHeadersFilter.HttpClientResponse(exchange.getResponse());
        this.handler.handleReceive((Object)response, null, (Span)storedSpan);
        if (log.isDebugEnabled()) {
            log.debug((Object)("The response was handled for span " + storedSpan));
        }
        return new HttpHeaders((MultiValueMap)input);
    }

    public boolean supports(HttpHeadersFilter.Type type) {
        return type.equals((Object)HttpHeadersFilter.Type.RESPONSE);
    }
}

