/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.redis;

import brave.Tracing;
import io.lettuce.core.tracing.BraveTracing;
import io.lettuce.core.tracing.TraceContextProvider;
import io.lettuce.core.tracing.TracerProvider;
import io.lettuce.core.tracing.Tracing;
import java.net.SocketAddress;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.cloud.sleuth.instrument.redis.NoOpTracing;
import org.springframework.cloud.sleuth.instrument.redis.TraceRedisProperties;
import org.springframework.cloud.sleuth.internal.ContextUtil;

class LazyTracing
implements io.lettuce.core.tracing.Tracing {
    private final BeanFactory beanFactory;
    private final io.lettuce.core.tracing.Tracing noOpTracing = NoOpTracing.INSTANCE;
    private BraveTracing braveTracing;

    LazyTracing(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    public TracerProvider getTracerProvider() {
        if (ContextUtil.isContextUnusable(this.beanFactory)) {
            return this.noOpTracing.getTracerProvider();
        }
        return this.braveTracing().getTracerProvider();
    }

    public TraceContextProvider initialTraceContextProvider() {
        if (ContextUtil.isContextUnusable(this.beanFactory)) {
            return this.noOpTracing.initialTraceContextProvider();
        }
        return this.braveTracing().initialTraceContextProvider();
    }

    public boolean isEnabled() {
        if (ContextUtil.isContextUnusable(this.beanFactory)) {
            return this.noOpTracing.isEnabled();
        }
        return this.braveTracing().isEnabled();
    }

    public boolean includeCommandArgsInSpanTags() {
        if (ContextUtil.isContextUnusable(this.beanFactory)) {
            return this.noOpTracing.includeCommandArgsInSpanTags();
        }
        return this.braveTracing().includeCommandArgsInSpanTags();
    }

    public Tracing.Endpoint createEndpoint(SocketAddress socketAddress) {
        if (ContextUtil.isContextUnusable(this.beanFactory)) {
            return this.noOpTracing.createEndpoint(socketAddress);
        }
        return this.braveTracing().createEndpoint(socketAddress);
    }

    private BraveTracing braveTracing() {
        if (this.braveTracing == null) {
            this.braveTracing = BraveTracing.builder().tracing((Tracing)this.beanFactory.getBean(Tracing.class)).excludeCommandArgsFromSpanTags().serviceName(((TraceRedisProperties)this.beanFactory.getBean(TraceRedisProperties.class)).getRemoteServiceName()).build();
        }
        return this.braveTracing;
    }
}

