/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.messaging;

import brave.Span;
import brave.SpanCustomizer;
import brave.Tracer;
import brave.Tracing;
import brave.propagation.Propagation;
import brave.propagation.ThreadLocalSpan;
import brave.propagation.TraceContext;
import brave.propagation.TraceContextOrSamplingFlags;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.sleuth.instrument.messaging.MessageHeaderPropagation;
import org.springframework.cloud.sleuth.instrument.messaging.MessageSpanCustomizer;
import org.springframework.cloud.sleuth.instrument.messaging.SleuthMessagingProperties;
import org.springframework.cloud.sleuth.util.SpanNameUtil;
import org.springframework.cloud.stream.binder.BinderTypeRegistry;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.integration.channel.AbstractMessageChannel;
import org.springframework.integration.channel.DirectChannel;
import org.springframework.integration.context.IntegrationObjectSupport;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.MessageHandler;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.MessagingException;
import org.springframework.messaging.support.ChannelInterceptorAdapter;
import org.springframework.messaging.support.ErrorMessage;
import org.springframework.messaging.support.ExecutorChannelInterceptor;
import org.springframework.messaging.support.GenericMessage;
import org.springframework.messaging.support.MessageHeaderAccessor;
import org.springframework.util.ClassUtils;

@Deprecated
public final class TracingChannelInterceptor
extends ChannelInterceptorAdapter
implements ExecutorChannelInterceptor,
ApplicationContextAware {
    public static final String STREAM_DIRECT_CHANNEL = "org.springframework.cloud.stream.messaging.DirectWithAttributesChannel";
    private static final Log log = LogFactory.getLog(TracingChannelInterceptor.class);
    private static final String REMOTE_SERVICE_NAME = "broker";
    final Tracing tracing;
    final Tracer tracer;
    final ThreadLocalSpan threadLocalSpan;
    final TraceContext.Injector<MessageHeaderAccessor> injector;
    final TraceContext.Extractor<MessageHeaderAccessor> extractor;
    final SleuthMessagingProperties properties;
    final MessageSpanCustomizer messageSpanCustomizer;
    final boolean integrationObjectSupportPresent;
    private final boolean hasDirectChannelClass;
    private final boolean hasBinderTypeRegistry;
    private final Class<?> directWithAttributesChannelClass;
    private ApplicationContext applicationContext;

    @Autowired
    TracingChannelInterceptor(Tracing tracing, SleuthMessagingProperties properties, MessageSpanCustomizer messageSpanCustomizer) {
        this(tracing, properties, MessageHeaderPropagation.INSTANCE, MessageHeaderPropagation.INSTANCE, messageSpanCustomizer);
    }

    TracingChannelInterceptor(Tracing tracing, SleuthMessagingProperties properties, Propagation.Setter<MessageHeaderAccessor, String> setter, Propagation.Getter<MessageHeaderAccessor, String> getter, MessageSpanCustomizer messageSpanCustomizer) {
        this.tracing = tracing;
        this.properties = properties;
        this.tracer = tracing.tracer();
        this.messageSpanCustomizer = messageSpanCustomizer;
        this.threadLocalSpan = ThreadLocalSpan.create((Tracer)this.tracer);
        this.injector = tracing.propagation().injector(setter);
        this.extractor = tracing.propagation().extractor(getter);
        this.integrationObjectSupportPresent = ClassUtils.isPresent((String)"org.springframework.integration.context.IntegrationObjectSupport", null);
        this.hasDirectChannelClass = ClassUtils.isPresent((String)"org.springframework.integration.channel.DirectChannel", null);
        this.hasBinderTypeRegistry = ClassUtils.isPresent((String)"org.springframework.cloud.stream.binder.BinderTypeRegistry", null);
        this.directWithAttributesChannelClass = ClassUtils.isPresent((String)STREAM_DIRECT_CHANNEL, null) ? ClassUtils.resolveClassName((String)STREAM_DIRECT_CHANNEL, null) : null;
    }

    public static TracingChannelInterceptor create(Tracing tracing, SleuthMessagingProperties properties, MessageSpanCustomizer messageSpanCustomizer) {
        return new TracingChannelInterceptor(tracing, properties, messageSpanCustomizer);
    }

    @Deprecated
    public Span nextSpan(Message<?> message) {
        MessageHeaderAccessor headers = this.mutableHeaderAccessor(message);
        TraceContextOrSamplingFlags extracted = this.extractor.extract((Object)headers);
        headers.setImmutable();
        Span result = this.tracer.nextSpan(extracted);
        if (extracted.context() == null && !result.isNoop()) {
            this.addTags(message, (SpanCustomizer)result, null);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Created a new span " + result));
        }
        return result;
    }

    public Message<?> preSend(Message<?> message, MessageChannel channel) {
        if (this.emptyMessage(message)) {
            return message;
        }
        Message<?> retrievedMessage = this.getMessage(message);
        MessageHeaderAccessor headers = this.mutableHeaderAccessor(retrievedMessage);
        TraceContextOrSamplingFlags extracted = this.extractor.extract((Object)headers);
        Span span = this.threadLocalSpan.next(extracted);
        MessageHeaderPropagation.removeAnyTraceHeaders(headers, this.tracing.propagation().keys());
        this.injector.inject(span.context(), (Object)headers);
        if (!span.isNoop()) {
            span.kind(Span.Kind.PRODUCER).start();
            this.messageSpanCustomizer.customizeSend((SpanCustomizer)span, message, channel);
            span.remoteServiceName(this.toRemoteServiceName(headers));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Created a new span in pre send" + span));
        }
        Message<?> outputMessage = this.outputMessage(message, retrievedMessage, headers);
        if (this.isDirectChannel(channel)) {
            this.beforeHandle(outputMessage, channel, null);
        }
        return outputMessage;
    }

    private String toRemoteServiceName(MessageHeaderAccessor headers) {
        BinderTypeRegistry typeRegistry;
        Iterator iterator;
        for (String key : headers.getMessageHeaders().keySet()) {
            if (key.startsWith("kafka_")) {
                return this.properties.getMessaging().getKafka().getRemoteServiceName();
            }
            if (!key.startsWith("amqp_")) continue;
            return this.properties.getMessaging().getRabbit().getRemoteServiceName();
        }
        if (this.hasBinderTypeRegistry && this.applicationContext != null && (iterator = (typeRegistry = (BinderTypeRegistry)this.applicationContext.getBean(BinderTypeRegistry.class)).getAll().entrySet().iterator()).hasNext()) {
            String binderName = (String)iterator.next().getKey();
            if (binderName.equals("kafka")) {
                return this.properties.getMessaging().getKafka().getRemoteServiceName();
            }
            if (binderName.equals("rabbit")) {
                return this.properties.getMessaging().getRabbit().getRemoteServiceName();
            }
        }
        return REMOTE_SERVICE_NAME;
    }

    private Message<?> outputMessage(Message<?> originalMessage, Message<?> retrievedMessage, MessageHeaderAccessor additionalHeaders) {
        MessageHeaderAccessor headers = this.mutableHeaderAccessor(originalMessage);
        if (originalMessage instanceof ErrorMessage) {
            ErrorMessage errorMessage = (ErrorMessage)originalMessage;
            headers.copyHeaders(MessageHeaderPropagation.propagationHeaders(additionalHeaders.getMessageHeaders(), this.tracing.propagation().keys()));
            return new ErrorMessage((Throwable)errorMessage.getPayload(), this.isWebSockets(headers) ? headers.getMessageHeaders() : new MessageHeaders((Map)headers.getMessageHeaders()), errorMessage.getOriginalMessage());
        }
        headers.copyHeaders((Map)new MessageHeaders((Map)additionalHeaders.getMessageHeaders()));
        return new GenericMessage(retrievedMessage.getPayload(), this.isWebSockets(headers) ? headers.getMessageHeaders() : new MessageHeaders((Map)headers.getMessageHeaders()));
    }

    private boolean isWebSockets(MessageHeaderAccessor headerAccessor) {
        return headerAccessor.getMessageHeaders().containsKey((Object)"stompCommand") || headerAccessor.getMessageHeaders().containsKey((Object)"simpMessageType");
    }

    private boolean isDirectChannel(MessageChannel channel) {
        boolean directChannel;
        Class targetClass = AopUtils.getTargetClass((Object)channel);
        boolean bl = directChannel = this.hasDirectChannelClass && DirectChannel.class.isAssignableFrom(targetClass);
        if (!directChannel) {
            return false;
        }
        if (this.directWithAttributesChannelClass == null) {
            return true;
        }
        return !this.isStreamSpecialDirectChannel(targetClass);
    }

    private boolean isStreamSpecialDirectChannel(Class<?> targetClass) {
        return this.directWithAttributesChannelClass.isAssignableFrom(targetClass);
    }

    public void afterSendCompletion(Message<?> message, MessageChannel channel, boolean sent, Exception ex) {
        if (this.emptyMessage(message)) {
            return;
        }
        if (this.isDirectChannel(channel)) {
            this.afterMessageHandled(message, channel, null, ex);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Will finish the current span after completion " + this.tracer.currentSpan()));
        }
        this.finishSpan(ex);
    }

    public Message<?> postReceive(Message<?> message, MessageChannel channel) {
        if (this.emptyMessage(message)) {
            return message;
        }
        MessageHeaderAccessor headers = this.mutableHeaderAccessor(message);
        TraceContextOrSamplingFlags extracted = this.extractor.extract((Object)headers);
        Span span = this.threadLocalSpan.next(extracted);
        MessageHeaderPropagation.removeAnyTraceHeaders(headers, this.tracing.propagation().keys());
        this.injector.inject(span.context(), (Object)headers);
        if (!span.isNoop()) {
            span.kind(Span.Kind.CONSUMER).start();
            this.messageSpanCustomizer.customizeReceive((SpanCustomizer)span, message, channel);
            span.remoteServiceName(this.toRemoteServiceName(headers));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Created a new span in post receive " + span));
        }
        headers.setImmutable();
        if (message instanceof ErrorMessage) {
            ErrorMessage errorMessage = (ErrorMessage)message;
            return new ErrorMessage((Throwable)errorMessage.getPayload(), headers.getMessageHeaders(), errorMessage.getOriginalMessage());
        }
        return new GenericMessage(message.getPayload(), headers.getMessageHeaders());
    }

    public void afterReceiveCompletion(Message<?> message, MessageChannel channel, Exception ex) {
        if (this.emptyMessage(message)) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Will finish the current span after receive completion " + this.tracer.currentSpan()));
        }
        this.finishSpan(ex);
    }

    public Message<?> beforeHandle(Message<?> message, MessageChannel channel, MessageHandler handler) {
        if (this.emptyMessage(message)) {
            return message;
        }
        MessageHeaderAccessor headers = this.mutableHeaderAccessor(message);
        TraceContextOrSamplingFlags extracted = this.extractor.extract((Object)headers);
        Span consumerSpan = this.tracer.nextSpan(extracted);
        if (!consumerSpan.isNoop()) {
            consumerSpan.kind(Span.Kind.CONSUMER).start();
            consumerSpan.remoteServiceName(REMOTE_SERVICE_NAME);
            this.addTags(message, (SpanCustomizer)consumerSpan, channel);
            consumerSpan.finish();
        }
        Span span = this.threadLocalSpan.next(TraceContextOrSamplingFlags.create((TraceContext)consumerSpan.context())).start();
        this.messageSpanCustomizer.customizeHandle((SpanCustomizer)span, message, channel);
        MessageHeaderPropagation.removeAnyTraceHeaders(headers, this.tracing.propagation().keys());
        if (log.isDebugEnabled()) {
            log.debug((Object)("Created a new span in before handle" + consumerSpan));
        }
        if (message instanceof ErrorMessage) {
            return new ErrorMessage((Throwable)message.getPayload(), headers.getMessageHeaders());
        }
        headers.setImmutable();
        return new GenericMessage(message.getPayload(), headers.getMessageHeaders());
    }

    public void afterMessageHandled(Message<?> message, MessageChannel channel, MessageHandler handler, Exception ex) {
        if (this.emptyMessage(message)) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Will finish the current span after message handled " + this.tracer.currentSpan()));
        }
        this.finishSpan(ex);
    }

    @Deprecated
    private void addTags(Message<?> message, SpanCustomizer result, MessageChannel channel) {
        if (channel != null) {
            result.tag("channel", this.messageChannelName(channel));
        }
    }

    @Deprecated
    private String channelName(MessageChannel channel) {
        String name = null;
        if (this.integrationObjectSupportPresent) {
            if (channel instanceof IntegrationObjectSupport) {
                name = ((IntegrationObjectSupport)channel).getComponentName();
            }
            if (name == null && channel instanceof AbstractMessageChannel) {
                name = ((AbstractMessageChannel)channel).getFullChannelName();
            }
        }
        if (name == null) {
            name = channel.toString();
        }
        return name;
    }

    @Deprecated
    private String messageChannelName(MessageChannel channel) {
        return SpanNameUtil.shorten(this.channelName(channel));
    }

    void finishSpan(Exception error) {
        Span span = this.threadLocalSpan.remove();
        if (span == null || span.isNoop()) {
            return;
        }
        if (error != null) {
            String message = error.getMessage();
            if (message == null) {
                message = error.getClass().getSimpleName();
            }
            span.tag("error", message);
        }
        span.finish();
    }

    private MessageHeaderAccessor mutableHeaderAccessor(Message<?> message) {
        MessageHeaderAccessor accessor = MessageHeaderAccessor.getAccessor(message, MessageHeaderAccessor.class);
        if (accessor != null && accessor.isMutable()) {
            return accessor;
        }
        MessageHeaderAccessor headers = MessageHeaderAccessor.getMutableAccessor(message);
        headers.setLeaveMutable(true);
        return headers;
    }

    private Message<?> getMessage(Message<?> message) {
        Object payload = message.getPayload();
        if (payload instanceof MessagingException) {
            MessagingException e = (MessagingException)payload;
            Message<?> failedMessage = e.getFailedMessage();
            return failedMessage != null ? failedMessage : message;
        }
        return message;
    }

    private boolean emptyMessage(Message<?> message) {
        return message == null;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

