/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.zuul;

import brave.Span;
import brave.Tracer;
import brave.http.HttpServerHandler;
import brave.http.HttpServerRequest;
import brave.http.HttpTracing;
import com.netflix.zuul.ZuulFilter;
import com.netflix.zuul.context.RequestContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.http.HttpStatus;

class TracePostZuulFilter
extends ZuulFilter {
    private static final Log log = LogFactory.getLog(TracePostZuulFilter.class);
    final HttpServerHandler<HttpServerRequest, brave.http.HttpServerResponse> handler;
    final Tracer tracer;

    TracePostZuulFilter(HttpTracing httpTracing) {
        this.handler = HttpServerHandler.create((HttpTracing)httpTracing);
        this.tracer = httpTracing.tracing().tracer();
    }

    public boolean shouldFilter() {
        return !this.httpStatusSuccessful(RequestContext.getCurrentContext().getResponse());
    }

    private boolean httpStatusSuccessful(HttpServletResponse response) {
        if (response.getStatus() == 0) {
            return false;
        }
        HttpStatus.Series httpStatusSeries = HttpStatus.Series.valueOf((int)response.getStatus());
        return httpStatusSeries == HttpStatus.Series.SUCCESSFUL || httpStatusSeries == HttpStatus.Series.REDIRECTION;
    }

    public Object run() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Marking current span as handled");
        }
        HttpServletRequest req = RequestContext.getCurrentContext().getRequest();
        HttpServletResponse resp = RequestContext.getCurrentContext().getResponse();
        HttpServerResponse request = resp != null ? new HttpServerResponse(req, resp) : null;
        Throwable exception = RequestContext.getCurrentContext().getThrowable();
        Span currentSpan = this.tracer.currentSpan();
        this.handler.handleSend((Object)request, exception, currentSpan);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Handled send of " + currentSpan));
        }
        return null;
    }

    public String filterType() {
        return "post";
    }

    public int filterOrder() {
        return 0;
    }

    static final class HttpServerResponse
    extends brave.http.HttpServerResponse {
        final HttpServletResponse delegate;
        final String method;
        final String httpRoute;

        HttpServerResponse(HttpServletRequest req, HttpServletResponse resp) {
            this.delegate = resp;
            this.method = req.getMethod();
            this.httpRoute = (String)req.getAttribute("http.route");
        }

        public String method() {
            return this.method;
        }

        public String route() {
            return this.httpRoute;
        }

        public HttpServletResponse unwrap() {
            return this.delegate;
        }

        public int statusCode() {
            return this.delegate.getStatus();
        }
    }
}

