/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.messaging;

import brave.Tracer;
import brave.kafka.clients.KafkaTracing;
import java.lang.reflect.Field;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.producer.Producer;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.springframework.aop.framework.ProxyFactoryBean;
import org.springframework.cloud.sleuth.instrument.messaging.MessageListenerMethodInterceptor;
import org.springframework.kafka.listener.AbstractMessageListenerContainer;
import org.springframework.kafka.listener.MessageListener;
import org.springframework.kafka.listener.MessageListenerContainer;
import org.springframework.kafka.listener.adapter.MessagingMessageListenerAdapter;
import org.springframework.util.ReflectionUtils;

@Aspect
class SleuthKafkaAspect {
    private static final Log log = LogFactory.getLog(SleuthKafkaAspect.class);
    final Field recordMessageConverter;
    private final KafkaTracing kafkaTracing;
    private final Tracer tracer;

    SleuthKafkaAspect(KafkaTracing kafkaTracing, Tracer tracer) {
        this.kafkaTracing = kafkaTracing;
        this.tracer = tracer;
        this.recordMessageConverter = ReflectionUtils.findField(MessagingMessageListenerAdapter.class, (String)"recordMessageConverter");
    }

    @Pointcut(value="execution(public * org.springframework.kafka.core.ProducerFactory.createProducer(..))")
    private void anyProducerFactory() {
    }

    @Pointcut(value="execution(public * org.springframework.kafka.core.ConsumerFactory.createConsumer(..))")
    private void anyConsumerFactory() {
    }

    @Pointcut(value="execution(public * org.springframework.kafka.config.KafkaListenerContainerFactory.createListenerContainer(..))")
    private void anyCreateListenerContainer() {
    }

    @Pointcut(value="execution(public * org.springframework.kafka.config.KafkaListenerContainerFactory.createContainer(..))")
    private void anyCreateContainer() {
    }

    @Around(value="anyProducerFactory()")
    public Object wrapProducerFactory(ProceedingJoinPoint pjp) throws Throwable {
        Producer producer = (Producer)pjp.proceed();
        return this.kafkaTracing.producer(producer);
    }

    @Around(value="anyConsumerFactory()")
    public Object wrapConsumerFactory(ProceedingJoinPoint pjp) throws Throwable {
        Consumer consumer = (Consumer)pjp.proceed();
        return this.kafkaTracing.consumer(consumer);
    }

    @Around(value="anyCreateListenerContainer() || anyCreateContainer()")
    public Object wrapListenerContainerCreation(ProceedingJoinPoint pjp) throws Throwable {
        MessageListenerContainer listener = (MessageListenerContainer)pjp.proceed();
        if (listener instanceof AbstractMessageListenerContainer) {
            AbstractMessageListenerContainer container = (AbstractMessageListenerContainer)listener;
            Object someMessageListener = container.getContainerProperties().getMessageListener();
            if (someMessageListener == null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"No message listener to wrap. Proceeding");
                }
            } else if (someMessageListener instanceof MessageListener) {
                container.setupMessageListener(this.createProxy(someMessageListener));
            } else if (log.isDebugEnabled()) {
                log.debug((Object)"ATM we don't support Batch message listeners");
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)"Can't wrap this listener. Proceeding");
        }
        return listener;
    }

    Object createProxy(Object bean) {
        ProxyFactoryBean factory = new ProxyFactoryBean();
        factory.setProxyTargetClass(true);
        factory.addAdvice(new MessageListenerMethodInterceptor(this.kafkaTracing, this.tracer));
        factory.setTarget(bean);
        return factory.getObject();
    }
}

