/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.sampler;

import brave.sampler.CountingSampler;
import brave.sampler.Sampler;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.cloud.sleuth.sampler.ProbabilityBasedSampler;
import org.springframework.cloud.sleuth.sampler.RateLimitingSampler;
import org.springframework.cloud.sleuth.sampler.SamplerCondition;
import org.springframework.cloud.sleuth.sampler.SamplerProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={SamplerProperties.class})
public class SamplerAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    Sampler sleuthTraceSampler() {
        return Sampler.NEVER_SAMPLE;
    }

    static Sampler samplerFromProps(SamplerProperties config) {
        if (config.getProbability() != null) {
            return CountingSampler.create((float)config.getProbability().floatValue());
        }
        return brave.sampler.RateLimitingSampler.create((int)config.getRate());
    }

    @Configuration(proxyBeanMethods=false)
    @Conditional(value={SamplerCondition.class})
    @ConditionalOnMissingBean(type={"org.springframework.cloud.context.scope.refresh.RefreshScope"})
    protected static class NonRefreshScopeSamplerConfiguration {
        protected NonRefreshScopeSamplerConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        public Sampler defaultTraceSampler(SamplerProperties config) {
            return SamplerAutoConfiguration.samplerFromProps(config);
        }
    }

    @Configuration(proxyBeanMethods=false)
    @Conditional(value={SamplerCondition.class})
    @ConditionalOnBean(type={"org.springframework.cloud.context.scope.refresh.RefreshScope"})
    protected static class RefreshScopedSamplerConfiguration {
        protected RefreshScopedSamplerConfiguration() {
        }

        @Bean
        @RefreshScope
        @ConditionalOnMissingBean
        public Sampler defaultTraceSampler(SamplerProperties config) {
            if (config.getProbability() != null) {
                return new ProbabilityBasedSampler(config);
            }
            return new RateLimitingSampler(config);
        }
    }
}

