/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.web.client.feign;

import brave.Span;
import brave.http.HttpClientHandler;
import brave.http.HttpClientRequest;
import brave.http.HttpClientResponse;
import brave.http.HttpTracing;
import brave.propagation.CurrentTraceContext;
import feign.Client;
import feign.Request;
import feign.RequestTemplate;
import feign.Response;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.util.ProxyUtils;
import org.springframework.lang.Nullable;

final class TracingFeignClient
implements Client {
    private static final Log log = LogFactory.getLog(TracingFeignClient.class);
    final CurrentTraceContext currentTraceContext;
    final Client delegate;
    final HttpClientHandler<HttpClientRequest, HttpClientResponse> handler;

    TracingFeignClient(HttpTracing httpTracing, Client delegate) {
        this.currentTraceContext = httpTracing.tracing().currentTraceContext();
        this.handler = HttpClientHandler.create((HttpTracing)httpTracing);
        Client delegateTarget = (Client)ProxyUtils.getTargetObject((Object)delegate);
        this.delegate = delegateTarget instanceof TracingFeignClient ? ((TracingFeignClient)delegateTarget).delegate : delegateTarget;
    }

    static Client create(HttpTracing httpTracing, Client delegate) {
        return new TracingFeignClient(httpTracing, delegate);
    }

    /*
     * Exception decompiling
     */
    public Response execute(Request req, Request.Options options) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    void handleSendAndReceive(Span span, Request req, @Nullable Response res, @Nullable Throwable error) {
        RequestWrapper request = new RequestWrapper(req);
        this.handler.handleSend((HttpClientRequest)request, span);
        ResponseWrapper response = res != null ? new ResponseWrapper(request, res, error) : null;
        this.handler.handleReceive((Object)response, error, span);
    }

    static final class ResponseWrapper
    extends HttpClientResponse {
        final RequestWrapper request;
        final Response response;
        @Nullable
        final Throwable error;

        ResponseWrapper(RequestWrapper request, Response response, @Nullable Throwable error) {
            this.request = request;
            this.response = response;
            this.error = error;
        }

        public Object unwrap() {
            return this.response;
        }

        public RequestWrapper request() {
            return this.request;
        }

        @Nullable
        public Throwable error() {
            return this.error;
        }

        public int statusCode() {
            return this.response.status();
        }
    }

    static final class RequestWrapper
    extends HttpClientRequest {
        final Request delegate;
        Map<String, Collection<String>> headers;

        RequestWrapper(Request delegate) {
            this.delegate = delegate;
        }

        public Object unwrap() {
            return this.delegate;
        }

        public String method() {
            return this.delegate.method();
        }

        public String path() {
            String url = this.url();
            if (url == null) {
                return null;
            }
            return URI.create(url).getPath();
        }

        public String url() {
            return this.delegate.url();
        }

        public String header(String name) {
            Collection result = (Collection)this.delegate.headers().get(name);
            return result != null && result.iterator().hasNext() ? (String)result.iterator().next() : null;
        }

        public void header(String name, String value) {
            if (this.headers == null) {
                this.headers = new LinkedHashMap<String, Collection<String>>(this.delegate.headers());
            }
            if (!this.headers.containsKey(name)) {
                this.headers.put(name, Collections.singletonList(value));
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Added key [" + name + "] and header value [" + value + "]"));
                }
            } else if (log.isTraceEnabled()) {
                log.trace((Object)("Key [" + name + "] already there in the headers"));
            }
        }

        Request build() {
            if (this.headers == null) {
                return this.delegate;
            }
            String url = this.delegate.url();
            byte[] body = this.delegate.body();
            Charset charset = this.delegate.charset();
            return Request.create((Request.HttpMethod)this.delegate.httpMethod(), (String)url, this.headers, (byte[])body, (Charset)charset, (RequestTemplate)this.delegate.requestTemplate());
        }
    }
}

