/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.web.client;

import brave.Span;
import brave.Tracer;
import brave.http.HttpClientHandler;
import brave.http.HttpTracing;
import brave.propagation.TraceContext;
import org.springframework.cloud.gateway.filter.headers.HttpHeadersFilter;
import org.springframework.http.HttpHeaders;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpResponse;

abstract class AbstractHttpHeadersFilter
implements HttpHeadersFilter {
    static final String SPAN_ATTRIBUTE = Span.class.getName();
    final Tracer tracer;
    final HttpClientHandler<brave.http.HttpClientRequest, brave.http.HttpClientResponse> handler;
    final HttpTracing httpTracing;
    final TraceContext.Extractor<HttpClientRequest> extractor;

    AbstractHttpHeadersFilter(HttpTracing httpTracing) {
        this.tracer = httpTracing.tracing().tracer();
        this.extractor = httpTracing.tracing().propagation().extractor(HttpClientRequest::header);
        this.handler = HttpClientHandler.create((HttpTracing)httpTracing);
        this.httpTracing = httpTracing;
    }

    static final class HttpClientResponse
    extends brave.http.HttpClientResponse {
        final ServerHttpResponse delegate;

        HttpClientResponse(ServerHttpResponse delegate) {
            this.delegate = delegate;
        }

        public Object unwrap() {
            return this.delegate;
        }

        public int statusCode() {
            return this.delegate.getStatusCode() != null ? this.delegate.getStatusCode().value() : 0;
        }
    }

    static final class HttpClientRequest
    extends brave.http.HttpClientRequest {
        final ServerHttpRequest delegate;
        final HttpHeaders filteredHeaders;

        HttpClientRequest(ServerHttpRequest delegate, HttpHeaders filteredHeaders) {
            this.delegate = delegate;
            this.filteredHeaders = filteredHeaders;
        }

        public Object unwrap() {
            return this.delegate;
        }

        public String method() {
            return this.delegate.getMethodValue();
        }

        public String path() {
            return this.delegate.getURI().getPath();
        }

        public String url() {
            return this.delegate.getURI().toString();
        }

        public String header(String name) {
            return this.filteredHeaders.getFirst(name);
        }

        public void header(String name, String value) {
            this.filteredHeaders.set(name, value);
        }
    }
}

