/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.messaging;

import javax.jms.ConnectionFactory;
import javax.jms.MessageListener;
import javax.jms.TopicConnectionFactory;
import javax.jms.XAConnectionFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.cloud.sleuth.instrument.messaging.LazyConnectionAndXaConnectionFactory;
import org.springframework.cloud.sleuth.instrument.messaging.LazyConnectionFactory;
import org.springframework.cloud.sleuth.instrument.messaging.LazyMessageListener;
import org.springframework.cloud.sleuth.instrument.messaging.LazyTopicConnectionFactory;
import org.springframework.cloud.sleuth.instrument.messaging.LazyXAConnectionFactory;
import org.springframework.jms.connection.CachingConnectionFactory;
import org.springframework.jms.listener.endpoint.JmsMessageEndpointManager;

class TracingConnectionFactoryBeanPostProcessor
implements BeanPostProcessor {
    private final BeanFactory beanFactory;

    TracingConnectionFactoryBeanPostProcessor(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof CachingConnectionFactory) {
            return new LazyConnectionFactory(this.beanFactory, (ConnectionFactory)((CachingConnectionFactory)bean));
        }
        if (bean instanceof JmsMessageEndpointManager) {
            JmsMessageEndpointManager manager = (JmsMessageEndpointManager)bean;
            MessageListener listener = manager.getMessageListener();
            if (listener != null) {
                manager.setMessageListener((MessageListener)new LazyMessageListener(this.beanFactory, listener));
            }
            return bean;
        }
        if (bean instanceof XAConnectionFactory && bean instanceof ConnectionFactory) {
            return new LazyConnectionAndXaConnectionFactory(this.beanFactory, (ConnectionFactory)bean, (XAConnectionFactory)bean);
        }
        if (bean instanceof XAConnectionFactory) {
            return new LazyXAConnectionFactory(this.beanFactory, (XAConnectionFactory)bean);
        }
        if (bean instanceof TopicConnectionFactory) {
            return new LazyTopicConnectionFactory(this.beanFactory, (TopicConnectionFactory)bean);
        }
        if (bean instanceof ConnectionFactory) {
            return new LazyConnectionFactory(this.beanFactory, (ConnectionFactory)bean);
        }
        return bean;
    }
}

