/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.messaging;

import brave.Span;
import brave.messaging.ConsumerRequest;
import brave.propagation.Propagation;
import org.springframework.messaging.Message;
import org.springframework.messaging.support.MessageHeaderAccessor;

final class MessageConsumerRequest
extends ConsumerRequest {
    static final Propagation.Getter<MessageConsumerRequest, String> GETTER = new Propagation.Getter<MessageConsumerRequest, String>(){

        public String get(MessageConsumerRequest request, String name) {
            return request.getHeader(name);
        }

        public String toString() {
            return "MessageConsumerRequest::getHeader";
        }
    };
    final Message delegate;
    final MessageHeaderAccessor mutableHeaders;
    final Propagation.Getter<MessageHeaderAccessor, String> getter;

    MessageConsumerRequest(Message delegate, Propagation.Getter<MessageHeaderAccessor, String> getter) {
        this.delegate = delegate;
        this.mutableHeaders = MessageHeaderAccessor.getMutableAccessor((Message)delegate);
        this.getter = getter;
    }

    public Span.Kind spanKind() {
        return Span.Kind.CONSUMER;
    }

    public Object unwrap() {
        return this.delegate;
    }

    public String operation() {
        return "receive";
    }

    public String channelKind() {
        return "queue";
    }

    public String channelName() {
        return this.delegate.getHeaders().get((Object)"LogicalResourceId").toString();
    }

    String getHeader(String name) {
        return this.getter.get((Object)this.mutableHeaders, (Object)name);
    }

    void removeHeader(String name) {
        this.mutableHeaders.removeHeader(name);
    }
}

