/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.web.client;

import brave.Span;
import brave.Tracer;
import brave.http.HttpClientAdapter;
import brave.http.HttpClientHandler;
import brave.http.HttpTracing;
import brave.propagation.Propagation;
import brave.propagation.TraceContext;
import java.util.List;
import org.springframework.cloud.gateway.filter.headers.HttpHeadersFilter;
import org.springframework.cloud.sleuth.instrument.web.client.TraceCarrier;
import org.springframework.http.server.reactive.ServerHttpResponse;

abstract class AbstractHttpHeadersFilter
implements HttpHeadersFilter {
    static final String SPAN_ATTRIBUTE = Span.class.getName();
    private static final Propagation.Setter<TraceCarrier, String> SETTER = new Propagation.Setter<TraceCarrier, String>(){

        public void put(TraceCarrier carrier, String key, String value) {
            carrier.filteredHeaders.set(key, value);
        }

        public String toString() {
            return "TraceCarrier::httpHeaders::set";
        }
    };
    private static final Propagation.Getter<TraceCarrier, String> GETTER = new Propagation.Getter<TraceCarrier, String>(){

        public String get(TraceCarrier carrier, String key) {
            return carrier.filteredHeaders.getFirst(key);
        }

        public String toString() {
            return "TraceCarrier::httpHeaders::getFirst";
        }
    };
    final Tracer tracer;
    final HttpClientHandler<TraceCarrier, ServerHttpResponse> handler;
    final TraceContext.Injector<TraceCarrier> injector;
    final TraceContext.Extractor<TraceCarrier> extractor;
    final HttpTracing httpTracing;

    AbstractHttpHeadersFilter(HttpTracing httpTracing) {
        this.tracer = httpTracing.tracing().tracer();
        this.handler = HttpClientHandler.create((HttpTracing)httpTracing, (HttpClientAdapter)new ServerHttpAdapter());
        this.injector = httpTracing.tracing().propagation().injector(SETTER);
        this.extractor = httpTracing.tracing().propagation().extractor(GETTER);
        this.httpTracing = httpTracing;
    }

    private static class ServerHttpAdapter
    extends HttpClientAdapter<TraceCarrier, ServerHttpResponse> {
        private ServerHttpAdapter() {
        }

        public String method(TraceCarrier request) {
            return request.originalRequest.getMethodValue();
        }

        public String url(TraceCarrier request) {
            return request.originalRequest.getURI().toString();
        }

        public String requestHeader(TraceCarrier request, String name) {
            List result = request.filteredHeaders.get((Object)name);
            return result != null ? result.toString() : "";
        }

        public Integer statusCode(ServerHttpResponse response) {
            return response.getStatusCode() != null ? Integer.valueOf(response.getStatusCode().value()) : null;
        }
    }
}

