/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.web;

import brave.http.HttpRequest;
import brave.sampler.SamplerFunction;
import org.springframework.cloud.sleuth.instrument.web.SleuthWebProperties;

class SkipPatternHttpClientSampler
implements SamplerFunction<HttpRequest> {
    private final SleuthWebProperties properties;

    SkipPatternHttpClientSampler(SleuthWebProperties properties) {
        this.properties = properties;
    }

    public Boolean trySample(HttpRequest request) {
        String path = request.path();
        if (path == null) {
            return null;
        }
        return path.matches(this.properties.getClient().getSkipPattern()) ? Boolean.valueOf(false) : null;
    }
}

