/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.quartz;

import brave.Tracing;
import org.quartz.JobListener;
import org.quartz.Scheduler;
import org.quartz.TriggerListener;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.quartz.QuartzAutoConfiguration;
import org.springframework.cloud.sleuth.autoconfig.TraceAutoConfiguration;
import org.springframework.cloud.sleuth.instrument.quartz.TracingJobListener;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@ConditionalOnBean(value={Tracing.class, Scheduler.class})
@AutoConfigureAfter(value={TraceAutoConfiguration.class, QuartzAutoConfiguration.class})
@ConditionalOnProperty(value={"spring.sleuth.quartz.enabled"}, matchIfMissing=true)
public class TraceQuartzAutoConfiguration
implements InitializingBean {
    private Scheduler scheduler;
    private Tracing tracing;
    @Autowired
    BeanFactory beanFactory;

    public TraceQuartzAutoConfiguration(Scheduler scheduler, Tracing tracing) {
        this.scheduler = scheduler;
        this.tracing = tracing;
    }

    @Bean
    public TracingJobListener tracingJobListener() {
        return new TracingJobListener(this.tracing);
    }

    public void afterPropertiesSet() throws Exception {
        TracingJobListener tracingJobListener = (TracingJobListener)this.beanFactory.getBean(TracingJobListener.class);
        this.scheduler.getListenerManager().addTriggerListener((TriggerListener)tracingJobListener);
        this.scheduler.getListenerManager().addJobListener((JobListener)tracingJobListener);
    }
}

