/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.messaging;

import brave.Span;
import brave.Tracer;
import brave.Tracing;
import brave.messaging.MessagingTracing;
import brave.propagation.Propagation;
import brave.propagation.TraceContext;
import brave.propagation.TraceContextOrSamplingFlags;
import java.util.function.BiConsumer;
import org.springframework.cloud.sleuth.instrument.messaging.MessageConsumerRequest;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHandler;
import org.springframework.messaging.support.MessageHeaderAccessor;

class TracingMethodMessageHandlerAdapter {
    private final Tracing tracing;
    private final Tracer tracer;
    private final TraceContext.Extractor<MessageConsumerRequest> extractor;
    private final Propagation.Getter<MessageHeaderAccessor, String> getter;

    TracingMethodMessageHandlerAdapter(MessagingTracing messagingTracing, Propagation.Getter<MessageHeaderAccessor, String> getter) {
        this.tracing = messagingTracing.tracing();
        this.tracer = this.tracing.tracer();
        this.extractor = this.tracing.propagation().extractor(MessageConsumerRequest.GETTER);
        this.getter = getter;
    }

    void wrapMethodMessageHandler(Message<?> message, MessageHandler messageHandler, BiConsumer<Span, Message<?>> messageSpanTagger) {
        MessageConsumerRequest request = new MessageConsumerRequest(message, this.getter);
        TraceContextOrSamplingFlags extracted = this.extractAndClearHeaders(request);
        Span consumerSpan = this.tracer.nextSpan(extracted);
        Span listenerSpan = this.tracer.newChild(consumerSpan.context());
        if (!consumerSpan.isNoop()) {
            consumerSpan.name("next-message").kind(Span.Kind.CONSUMER);
            if (messageSpanTagger != null) {
                messageSpanTagger.accept(consumerSpan, message);
            }
            long timestamp = this.tracing.clock(consumerSpan.context()).currentTimeMicroseconds();
            consumerSpan.start(timestamp);
            long consumerFinish = timestamp + 1L;
            consumerSpan.finish(consumerFinish);
            listenerSpan.name("on-message").start(consumerFinish);
        }
        try (Tracer.SpanInScope ws = this.tracer.withSpanInScope(listenerSpan);){
            messageHandler.handleMessage(message);
        }
        catch (Throwable t) {
            listenerSpan.error(t);
            throw t;
        }
        finally {
            listenerSpan.finish();
        }
    }

    private TraceContextOrSamplingFlags extractAndClearHeaders(MessageConsumerRequest request) {
        TraceContextOrSamplingFlags extracted = this.extractor.extract((Object)request);
        for (String propagationKey : this.tracing.propagation().keys()) {
            request.removeHeader(propagationKey);
        }
        return extracted;
    }
}

