/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.messaging;

import brave.propagation.Propagation;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.sleuth.instrument.messaging.MessageHeaderPropagation;
import org.springframework.cloud.sleuth.instrument.messaging.OnMessagingEnabled;
import org.springframework.cloud.sleuth.instrument.messaging.SleuthMessagingProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.messaging.support.MessageHeaderAccessor;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={MessageHeaderAccessor.class})
@OnMessagingEnabled
@EnableConfigurationProperties(value={SleuthMessagingProperties.class})
class TraceSpringMessagingAutoConfiguration {
    TraceSpringMessagingAutoConfiguration() {
    }

    @Bean
    @ConditionalOnMissingBean
    Propagation.Setter<MessageHeaderAccessor, String> traceMessagePropagationSetter() {
        return MessageHeaderPropagation.INSTANCE;
    }

    @Bean
    @ConditionalOnMissingBean
    Propagation.Getter<MessageHeaderAccessor, String> traceMessagePropagationGetter() {
        return MessageHeaderPropagation.INSTANCE;
    }
}

