/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.messaging;

import brave.kafka.streams.KafkaStreamsTracing;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.kafka.config.StreamsBuilderFactoryBean;

class KafkaStreamsBuilderFactoryBeanPostProcessor
implements BeanPostProcessor {
    private static final Log log = LogFactory.getLog(KafkaStreamsBuilderFactoryBeanPostProcessor.class);
    private final KafkaStreamsTracing kafkaStreamsTracing;

    KafkaStreamsBuilderFactoryBeanPostProcessor(KafkaStreamsTracing kafkaStreamsTracing) {
        this.kafkaStreamsTracing = kafkaStreamsTracing;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof StreamsBuilderFactoryBean) {
            StreamsBuilderFactoryBean sbfb = (StreamsBuilderFactoryBean)bean;
            if (log.isDebugEnabled()) {
                log.debug((Object)"StreamsBuilderFactoryBean bean is auto-configured to enable tracing.");
            }
            sbfb.setClientSupplier(this.kafkaStreamsTracing.kafkaClientSupplier());
        }
        return bean;
    }
}

