/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.grpc;

import brave.grpc.GrpcTracing;
import brave.rpc.RpcTracing;
import io.grpc.ServerInterceptor;
import java.util.List;
import java.util.Optional;
import org.lognet.springboot.grpc.GRpcGlobalInterceptor;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.sleuth.instrument.grpc.GrpcManagedChannelBuilderCustomizer;
import org.springframework.cloud.sleuth.instrument.grpc.SpringAwareManagedChannelBuilder;
import org.springframework.cloud.sleuth.instrument.grpc.TracingManagedChannelBuilderCustomizer;
import org.springframework.cloud.sleuth.instrument.rpc.TraceRpcAutoConfiguration;
import org.springframework.context.annotation.Bean;

@ConditionalOnClass(value={GrpcTracing.class, GRpcGlobalInterceptor.class})
@ConditionalOnProperty(value={"spring.sleuth.grpc.enabled"}, matchIfMissing=true)
@ConditionalOnBean(value={RpcTracing.class})
@AutoConfigureAfter(value={TraceRpcAutoConfiguration.class})
public class TraceGrpcAutoConfiguration {
    @Bean
    public GrpcTracing grpcTracing(RpcTracing rpcTracing) {
        return GrpcTracing.create((RpcTracing)rpcTracing);
    }

    @Bean
    @GRpcGlobalInterceptor
    ServerInterceptor grpcServerBraveInterceptor(GrpcTracing grpcTracing) {
        return grpcTracing.newServerInterceptor();
    }

    @Bean
    @ConditionalOnMissingBean(value={SpringAwareManagedChannelBuilder.class})
    public SpringAwareManagedChannelBuilder managedChannelBuilder(Optional<List<GrpcManagedChannelBuilderCustomizer>> customizers) {
        return new SpringAwareManagedChannelBuilder(customizers);
    }

    @Bean
    GrpcManagedChannelBuilderCustomizer tracingManagedChannelBuilderCustomizer(GrpcTracing grpcTracing) {
        return new TracingManagedChannelBuilderCustomizer(grpcTracing);
    }
}

