/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.annotation;

import brave.SpanCustomizer;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.cloud.sleuth.annotation.NoOpTagValueResolver;
import org.springframework.cloud.sleuth.annotation.SleuthAnnotatedParameter;
import org.springframework.cloud.sleuth.annotation.SleuthAnnotationUtils;
import org.springframework.cloud.sleuth.annotation.SpanTag;
import org.springframework.cloud.sleuth.annotation.TagValueExpressionResolver;
import org.springframework.cloud.sleuth.annotation.TagValueResolver;
import org.springframework.util.StringUtils;

class SpanTagAnnotationHandler {
    private static final Log log = LogFactory.getLog(SpanTagAnnotationHandler.class);
    private final BeanFactory beanFactory;
    private SpanCustomizer spanCustomizer;

    SpanTagAnnotationHandler(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    void addAnnotatedParameters(MethodInvocation pjp) {
        try {
            Method method = pjp.getMethod();
            Method mostSpecificMethod = AopUtils.getMostSpecificMethod((Method)method, pjp.getThis().getClass());
            List<SleuthAnnotatedParameter> annotatedParameters = SleuthAnnotationUtils.findAnnotatedParameters(mostSpecificMethod, pjp.getArguments());
            this.getAnnotationsFromInterfaces(pjp, mostSpecificMethod, annotatedParameters);
            this.mergeAnnotatedMethodsIfNecessary(pjp, method, mostSpecificMethod, annotatedParameters);
            this.addAnnotatedArguments(annotatedParameters);
        }
        catch (SecurityException ex) {
            log.error((Object)"Exception occurred while trying to add annotated parameters", (Throwable)ex);
        }
    }

    private void getAnnotationsFromInterfaces(MethodInvocation pjp, Method mostSpecificMethod, List<SleuthAnnotatedParameter> annotatedParameters) {
        Class<?>[] implementedInterfaces = pjp.getThis().getClass().getInterfaces();
        if (implementedInterfaces.length > 0) {
            for (Class<?> implementedInterface : implementedInterfaces) {
                for (Method methodFromInterface : implementedInterface.getMethods()) {
                    if (!this.methodsAreTheSame(mostSpecificMethod, methodFromInterface)) continue;
                    List<SleuthAnnotatedParameter> annotatedParametersForActualMethod = SleuthAnnotationUtils.findAnnotatedParameters(methodFromInterface, pjp.getArguments());
                    this.mergeAnnotatedParameters(annotatedParameters, annotatedParametersForActualMethod);
                }
            }
        }
    }

    private boolean methodsAreTheSame(Method mostSpecificMethod, Method method1) {
        return method1.getName().equals(mostSpecificMethod.getName()) && Arrays.equals(method1.getParameterTypes(), mostSpecificMethod.getParameterTypes());
    }

    private void mergeAnnotatedMethodsIfNecessary(MethodInvocation pjp, Method method, Method mostSpecificMethod, List<SleuthAnnotatedParameter> annotatedParameters) {
        if (!method.equals(mostSpecificMethod)) {
            List<SleuthAnnotatedParameter> annotatedParametersForActualMethod = SleuthAnnotationUtils.findAnnotatedParameters(method, pjp.getArguments());
            this.mergeAnnotatedParameters(annotatedParameters, annotatedParametersForActualMethod);
        }
    }

    private void mergeAnnotatedParameters(List<SleuthAnnotatedParameter> annotatedParametersIndices, List<SleuthAnnotatedParameter> annotatedParametersIndicesForActualMethod) {
        for (SleuthAnnotatedParameter container : annotatedParametersIndicesForActualMethod) {
            int index = container.parameterIndex;
            boolean parameterContained = false;
            for (SleuthAnnotatedParameter parameterContainer : annotatedParametersIndices) {
                if (parameterContainer.parameterIndex != index) continue;
                parameterContained = true;
                break;
            }
            if (parameterContained) continue;
            annotatedParametersIndices.add(container);
        }
    }

    private void addAnnotatedArguments(List<SleuthAnnotatedParameter> toBeAdded) {
        for (SleuthAnnotatedParameter container : toBeAdded) {
            String tagValue = this.resolveTagValue(container.annotation, container.argument);
            String tagKey = this.resolveTagKey(container);
            this.span().tag(tagKey, tagValue);
        }
    }

    private SpanCustomizer span() {
        if (this.spanCustomizer == null) {
            this.spanCustomizer = (SpanCustomizer)this.beanFactory.getBean(SpanCustomizer.class);
        }
        return this.spanCustomizer;
    }

    private String resolveTagKey(SleuthAnnotatedParameter container) {
        return StringUtils.hasText((String)container.annotation.value()) ? container.annotation.value() : container.annotation.key();
    }

    String resolveTagValue(SpanTag annotation, Object argument) {
        if (argument == null) {
            return "";
        }
        if (annotation.resolver() != NoOpTagValueResolver.class) {
            TagValueResolver tagValueResolver = (TagValueResolver)this.beanFactory.getBean(annotation.resolver());
            return tagValueResolver.resolve(argument);
        }
        if (StringUtils.hasText((String)annotation.expression())) {
            return ((TagValueExpressionResolver)this.beanFactory.getBean(TagValueExpressionResolver.class)).resolve(annotation.expression(), argument);
        }
        return argument.toString();
    }
}

