/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.web.client;

import brave.Span;
import brave.Tracer;
import brave.Tracing;
import brave.http.HttpClientAdapter;
import brave.http.HttpClientHandler;
import brave.http.HttpTracing;
import brave.propagation.Propagation;
import brave.propagation.TraceContext;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscription;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.cloud.sleuth.instrument.reactor.ReactorSleuth;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseCookie;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.reactive.ClientHttpResponse;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestClientException;
import org.springframework.web.reactive.function.BodyExtractor;
import org.springframework.web.reactive.function.client.ClientRequest;
import org.springframework.web.reactive.function.client.ClientResponse;
import org.springframework.web.reactive.function.client.ExchangeFilterFunction;
import org.springframework.web.reactive.function.client.ExchangeFunction;
import org.springframework.web.reactive.function.client.ExchangeStrategies;
import reactor.core.CoreSubscriber;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.annotation.Nullable;
import reactor.util.context.Context;

final class TraceExchangeFilterFunction
implements ExchangeFilterFunction {
    private static final Log log = LogFactory.getLog(TraceExchangeFilterFunction.class);
    static final Propagation.Setter<ClientRequest.Builder, String> SETTER = new Propagation.Setter<ClientRequest.Builder, String>(){

        public void put(ClientRequest.Builder carrier, String key, String value) {
            carrier.headers(httpHeaders -> {
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Replacing [" + key + "] with value [" + value + "]"));
                }
                httpHeaders.merge((Object)key, Collections.singletonList(value), (oldValue, newValue) -> newValue);
            });
        }

        public String toString() {
            return "ClientRequest.Builder::header";
        }
    };
    private static final String CLIENT_SPAN_KEY = "sleuth.webclient.clientSpan";
    private static final String CANCELLED_SUBSCRIPTION_ERROR = "CANCELLED";
    final BeanFactory beanFactory;
    final Function<? super Publisher<DataBuffer>, ? extends Publisher<DataBuffer>> scopePassingTransformer;
    Tracer tracer;
    HttpTracing httpTracing;
    HttpClientHandler<ClientRequest, ClientResponse> handler;
    TraceContext.Injector<ClientRequest.Builder> injector;

    TraceExchangeFilterFunction(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
        this.scopePassingTransformer = ReactorSleuth.scopePassingSpanOperator(beanFactory);
    }

    public static ExchangeFilterFunction create(BeanFactory beanFactory) {
        return new TraceExchangeFilterFunction(beanFactory);
    }

    public Mono<ClientResponse> filter(ClientRequest request, ExchangeFunction next) {
        ClientRequest.Builder builder = ClientRequest.from((ClientRequest)request);
        if (log.isDebugEnabled()) {
            log.debug((Object)"Instrumenting WebClient call");
        }
        Span span = this.handler().handleSend(this.injector(), (Object)builder, (Object)request, this.tracer().nextSpan());
        if (log.isDebugEnabled()) {
            log.debug((Object)("Handled send of " + span));
        }
        return new MonoWebClientTrace(next, builder.build(), this, span);
    }

    HttpClientHandler<ClientRequest, ClientResponse> handler() {
        if (this.handler == null) {
            this.handler = HttpClientHandler.create((HttpTracing)((HttpTracing)this.beanFactory.getBean(HttpTracing.class)), (HttpClientAdapter)new HttpAdapter());
        }
        return this.handler;
    }

    Tracer tracer() {
        if (this.tracer == null) {
            this.tracer = this.httpTracing().tracing().tracer();
        }
        return this.tracer;
    }

    HttpTracing httpTracing() {
        if (this.httpTracing == null) {
            this.httpTracing = (HttpTracing)this.beanFactory.getBean(HttpTracing.class);
        }
        return this.httpTracing;
    }

    TraceContext.Injector<ClientRequest.Builder> injector() {
        if (this.injector == null) {
            this.injector = ((HttpTracing)this.beanFactory.getBean(HttpTracing.class)).tracing().propagation().injector(SETTER);
        }
        return this.injector;
    }

    static final class HttpAdapter
    extends HttpClientAdapter<ClientRequest, ClientResponse> {
        HttpAdapter() {
        }

        public String method(ClientRequest request) {
            return request.method().name();
        }

        public String url(ClientRequest request) {
            return request.url().toString();
        }

        public String requestHeader(ClientRequest request, String name) {
            String result = request.headers().getFirst(name);
            return result != null ? result.toString() : null;
        }

        public Integer statusCode(ClientResponse response) {
            int result = this.statusCodeAsInt(response);
            return result != 0 ? Integer.valueOf(result) : null;
        }

        public int statusCodeAsInt(ClientResponse response) {
            try {
                return response.rawStatusCode();
            }
            catch (Exception dontCare) {
                return 0;
            }
        }
    }

    private static final class MonoWebClientTrace
    extends Mono<ClientResponse> {
        final ExchangeFunction next;
        final ClientRequest request;
        final Tracer tracer;
        final HttpClientHandler<ClientRequest, ClientResponse> handler;
        final TraceContext.Injector<ClientRequest.Builder> injector;
        final Tracing tracing;
        final Function<? super Publisher<DataBuffer>, ? extends Publisher<DataBuffer>> scopePassingTransformer;
        private final Span span;

        MonoWebClientTrace(ExchangeFunction next, ClientRequest request, TraceExchangeFilterFunction parent, Span span) {
            this.next = next;
            this.request = request;
            this.tracer = parent.tracer();
            this.handler = parent.handler();
            this.injector = parent.injector();
            this.tracing = parent.httpTracing().tracing();
            this.scopePassingTransformer = parent.scopePassingTransformer;
            this.span = span;
        }

        public void subscribe(CoreSubscriber<? super ClientResponse> subscriber) {
            Context context = subscriber.currentContext();
            this.next.exchange(this.request).subscribe((CoreSubscriber)new WebClientTracerSubscriber(subscriber, context, this.span, this));
        }

        static final class WebClientTracerSubscriber
        implements CoreSubscriber<ClientResponse> {
            final CoreSubscriber<? super ClientResponse> actual;
            final Context context;
            final Span span;
            final Tracer.SpanInScope ws;
            final HttpClientHandler<ClientRequest, ClientResponse> handler;
            final Function<? super Publisher<DataBuffer>, ? extends Publisher<DataBuffer>> scopePassingTransformer;
            final Tracing tracing;
            boolean done;

            WebClientTracerSubscriber(CoreSubscriber<? super ClientResponse> actual, Context context, Span span, MonoWebClientTrace parent) {
                this.actual = actual;
                this.span = span;
                this.handler = parent.handler;
                this.tracing = parent.tracing;
                this.scopePassingTransformer = parent.scopePassingTransformer;
                if (!context.hasKey(Span.class)) {
                    context = context.put(Span.class, (Object)span);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Reactor Context got injected with the client span " + span));
                    }
                }
                this.context = context.put((Object)TraceExchangeFilterFunction.CLIENT_SPAN_KEY, (Object)span);
                this.ws = parent.tracer.withSpanInScope(span);
            }

            public void onSubscribe(final Subscription subscription) {
                this.actual.onSubscribe(new Subscription(){

                    public void request(long n) {
                        subscription.request(n);
                    }

                    public void cancel() {
                        this.terminateSpanOnCancel();
                        subscription.cancel();
                    }
                });
            }

            public void onNext(ClientResponse response) {
                this.done = true;
                try {
                    this.actual.onNext((Object)this.wrapped(response));
                }
                finally {
                    this.terminateSpan(response, null);
                }
            }

            private ClientResponse wrapped(final ClientResponse response) {
                return new ClientResponse(){

                    public HttpStatus statusCode() {
                        try {
                            return response.statusCode();
                        }
                        catch (IllegalArgumentException ex) {
                            return null;
                        }
                    }

                    public int rawStatusCode() {
                        return response.rawStatusCode();
                    }

                    public ClientResponse.Headers headers() {
                        return response.headers();
                    }

                    public MultiValueMap<String, ResponseCookie> cookies() {
                        return response.cookies();
                    }

                    public ExchangeStrategies strategies() {
                        return response.strategies();
                    }

                    public <T> T body(BodyExtractor<T, ? super ClientHttpResponse> extractor) {
                        return (T)response.body(extractor);
                    }

                    public <T> Mono<T> bodyToMono(Class<? extends T> elementClass) {
                        return response.bodyToMono(elementClass);
                    }

                    public <T> Mono<T> bodyToMono(ParameterizedTypeReference<T> typeReference) {
                        return response.bodyToMono(typeReference);
                    }

                    public <T> Flux<T> bodyToFlux(Class<? extends T> elementClass) {
                        return response.bodyToFlux(DataBuffer.class).transform(scopePassingTransformer);
                    }

                    public <T> Flux<T> bodyToFlux(ParameterizedTypeReference<T> typeReference) {
                        return response.bodyToFlux(DataBuffer.class).transform(scopePassingTransformer);
                    }

                    public <T> Mono<ResponseEntity<T>> toEntity(Class<T> bodyType) {
                        return response.toEntity(bodyType);
                    }

                    public <T> Mono<ResponseEntity<T>> toEntity(ParameterizedTypeReference<T> typeReference) {
                        return response.toEntity(typeReference);
                    }

                    public <T> Mono<ResponseEntity<List<T>>> toEntityList(Class<T> elementType) {
                        return response.toEntityList(elementType);
                    }

                    public <T> Mono<ResponseEntity<List<T>>> toEntityList(ParameterizedTypeReference<T> typeReference) {
                        return response.toEntityList(typeReference);
                    }
                };
            }

            public void onError(Throwable t) {
                try {
                    this.actual.onError(t);
                }
                finally {
                    this.terminateSpan(null, t);
                }
            }

            public void onComplete() {
                try {
                    this.actual.onComplete();
                }
                finally {
                    if (!this.done) {
                        this.terminateSpan(null, null);
                    }
                }
            }

            public Context currentContext() {
                return this.context;
            }

            void handleReceive(Span clientSpan, Tracer.SpanInScope ws, ClientResponse clientResponse, Throwable throwable) {
                this.handler.handleReceive((Object)clientResponse, throwable, clientSpan);
                ws.close();
            }

            void terminateSpanOnCancel() {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Subscription was cancelled. Will close the span [" + this.span + "]"));
                }
                this.span.tag("error", TraceExchangeFilterFunction.CANCELLED_SUBSCRIPTION_ERROR);
                this.handleReceive(this.span, this.ws, null, null);
            }

            void terminateSpan(@Nullable ClientResponse clientResponse, @Nullable Throwable throwable) {
                if (clientResponse == null) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("No response was returned. Will close the span [" + this.span + "]"));
                    }
                    this.handleReceive(this.span, this.ws, clientResponse, throwable);
                    return;
                }
                int statusCode = this.statusCodeAsInt(clientResponse);
                boolean error = this.isError(statusCode);
                if (error) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Non positive status code was returned from the call. Will close the span [" + this.span + "]"));
                    }
                    throwable = new RestClientException("Status code of the response is [" + statusCode + "] and the reason is [" + this.reasonPhrase(clientResponse) + "]");
                }
                this.handleReceive(this.span, this.ws, clientResponse, throwable);
            }

            private String reasonPhrase(ClientResponse clientResponse) {
                try {
                    return clientResponse.statusCode().getReasonPhrase();
                }
                catch (IllegalArgumentException ex) {
                    return "";
                }
            }

            private boolean isError(int code) {
                return code >= 400;
            }

            private int statusCodeAsInt(ClientResponse response) {
                try {
                    return response.rawStatusCode();
                }
                catch (Exception dontCare) {
                    return 0;
                }
            }
        }
    }
}

