/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.web;

import brave.Tracing;
import brave.http.HttpTracing;
import brave.servlet.TracingFilter;
import brave.spring.webmvc.SpanCustomizingAsyncHandlerInterceptor;
import java.io.IOException;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.cloud.sleuth.SpanNamer;
import org.springframework.cloud.sleuth.instrument.web.ExceptionLoggingFilter;
import org.springframework.cloud.sleuth.instrument.web.SleuthWebProperties;
import org.springframework.cloud.sleuth.instrument.web.TraceHttpAutoConfiguration;
import org.springframework.cloud.sleuth.instrument.web.TraceSpringDataBeanPostProcessor;
import org.springframework.cloud.sleuth.instrument.web.TraceWebAspect;
import org.springframework.cloud.sleuth.instrument.web.TraceWebMvcConfigurer;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
@ConditionalOnProperty(value={"spring.sleuth.web.enabled"}, matchIfMissing=true)
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
@ConditionalOnBean(value={HttpTracing.class})
@AutoConfigureAfter(value={TraceHttpAutoConfiguration.class})
@Import(value={SpanCustomizingAsyncHandlerInterceptor.class})
public class TraceWebServletAutoConfiguration {
    public static final int TRACING_FILTER_ORDER = -2147483643;

    @Bean
    @ConditionalOnClass(name={"org.springframework.data.rest.webmvc.support.DelegatingHandlerMapping"})
    public static TraceSpringDataBeanPostProcessor traceSpringDataBeanPostProcessor(ApplicationContext applicationContext) {
        return new TraceSpringDataBeanPostProcessor(applicationContext);
    }

    @Bean
    TraceWebAspect traceWebAspect(Tracing tracing, SpanNamer spanNamer) {
        return new TraceWebAspect(tracing, spanNamer);
    }

    @Bean
    public FilterRegistrationBean traceWebFilter(BeanFactory beanFactory, SleuthWebProperties webProperties) {
        FilterRegistrationBean filterRegistrationBean = new FilterRegistrationBean((Filter)new LazyTracingFilter(beanFactory), new ServletRegistrationBean[0]);
        filterRegistrationBean.setDispatcherTypes(DispatcherType.ASYNC, new DispatcherType[]{DispatcherType.ERROR, DispatcherType.FORWARD, DispatcherType.INCLUDE, DispatcherType.REQUEST});
        filterRegistrationBean.setOrder(webProperties.getFilterOrder());
        return filterRegistrationBean;
    }

    @Bean
    @ConditionalOnProperty(value={"spring.sleuth.web.exception-logging-filter-enabled"}, matchIfMissing=true)
    public FilterRegistrationBean exceptionThrowingFilter(SleuthWebProperties webProperties) {
        FilterRegistrationBean filterRegistrationBean = new FilterRegistrationBean((Filter)new ExceptionLoggingFilter(), new ServletRegistrationBean[0]);
        filterRegistrationBean.setDispatcherTypes(DispatcherType.ASYNC, new DispatcherType[]{DispatcherType.ERROR, DispatcherType.FORWARD, DispatcherType.INCLUDE, DispatcherType.REQUEST});
        filterRegistrationBean.setOrder(webProperties.getFilterOrder());
        return filterRegistrationBean;
    }

    @Bean
    @ConditionalOnMissingBean
    public TracingFilter tracingFilter(HttpTracing tracing) {
        return (TracingFilter)TracingFilter.create((HttpTracing)tracing);
    }

    private static final class LazyTracingFilter
    implements Filter {
        private final BeanFactory beanFactory;
        private Filter tracingFilter;

        private LazyTracingFilter(BeanFactory beanFactory) {
            this.beanFactory = beanFactory;
        }

        public void init(FilterConfig filterConfig) throws ServletException {
            this.tracingFilter().init(filterConfig);
        }

        public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
            this.tracingFilter().doFilter(request, response, chain);
        }

        public void destroy() {
            this.tracingFilter().destroy();
        }

        private Filter tracingFilter() {
            if (this.tracingFilter == null) {
                this.tracingFilter = (Filter)this.beanFactory.getBean(TracingFilter.class);
            }
            return this.tracingFilter;
        }
    }

    @Configuration
    @ConditionalOnClass(value={WebMvcConfigurer.class})
    @Import(value={TraceWebMvcConfigurer.class})
    protected static class TraceWebMvcAutoConfiguration {
        protected TraceWebMvcAutoConfiguration() {
        }
    }
}

