/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.reactor;

import brave.Span;
import brave.Tracing;
import java.util.function.Supplier;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.reactivestreams.Subscriber;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.cloud.sleuth.instrument.reactor.ScopePassingSpanSubscriber;
import org.springframework.cloud.sleuth.instrument.reactor.SpanSubscription;
import reactor.util.context.Context;

final class SpanSubscriptionProvider<T>
implements Supplier<SpanSubscription<T>> {
    private static final Log log = LogFactory.getLog(SpanSubscriptionProvider.class);
    final BeanFactory beanFactory;
    final Subscriber<? super T> subscriber;
    final Context context;
    final String name;
    private volatile Tracing tracing;

    SpanSubscriptionProvider(BeanFactory beanFactory, Subscriber<? super T> subscriber, Context context, String name) {
        this.beanFactory = beanFactory;
        this.subscriber = subscriber;
        this.context = context;
        this.name = name;
        if (log.isTraceEnabled()) {
            log.trace((Object)("Spring context [" + beanFactory + "], Reactor context [" + context + "], name [" + name + "]"));
        }
    }

    @Override
    public SpanSubscription<T> get() {
        return this.newCoreSubscriber(this.tracing());
    }

    SpanSubscription<T> newCoreSubscriber(Tracing tracing) {
        Span root = this.context.hasKey(Span.class) ? (Span)this.context.get(Span.class) : tracing.tracer().currentSpan();
        return new ScopePassingSpanSubscriber<T>(this.subscriber, this.context, tracing, root);
    }

    private Tracing tracing() {
        if (this.tracing == null) {
            this.tracing = (Tracing)this.beanFactory.getBean(Tracing.class);
        }
        return this.tracing;
    }
}

