/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.web;

import brave.http.HttpAdapter;
import brave.http.HttpSampler;

class CompositeHttpSampler
extends HttpSampler {
    private final HttpSampler left;
    private final HttpSampler right;

    CompositeHttpSampler(HttpSampler left, HttpSampler right) {
        this.left = left;
        this.right = right;
    }

    public <Req> Boolean trySample(HttpAdapter<Req, ?> adapter, Req request) {
        Boolean leftDecision = this.left.trySample(adapter, request);
        if (Boolean.FALSE.equals(leftDecision)) {
            return false;
        }
        Boolean rightDecision = this.right.trySample(adapter, request);
        if (Boolean.FALSE.equals(rightDecision)) {
            return false;
        }
        if (leftDecision == null) {
            return rightDecision;
        }
        if (rightDecision == null) {
            return leftDecision;
        }
        return leftDecision != false && rightDecision != false;
    }
}

