/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.reactor;

import brave.Tracing;
import javax.annotation.PreDestroy;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.sleuth.instrument.reactor.HookRegisteringBeanDefinitionRegistryPostProcessor;
import org.springframework.cloud.sleuth.instrument.web.TraceWebFluxAutoConfiguration;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import reactor.core.publisher.Hooks;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

@Configuration
@ConditionalOnProperty(value={"spring.sleuth.reactor.enabled"}, matchIfMissing=true)
@ConditionalOnClass(value={Mono.class})
@AutoConfigureAfter(value={TraceWebFluxAutoConfiguration.class})
public class TraceReactorAutoConfiguration {
    static final String SLEUTH_REACTOR_EXECUTOR_SERVICE_KEY = "sleuth";

    @Configuration
    @ConditionalOnBean(value={Tracing.class})
    static class TraceReactorConfiguration {
        static final String SLEUTH_TRACE_REACTOR_KEY = TraceReactorConfiguration.class.getName();
        private static final Log log = LogFactory.getLog(TraceReactorConfiguration.class);

        TraceReactorConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        static HookRegisteringBeanDefinitionRegistryPostProcessor traceHookRegisteringBeanDefinitionRegistryPostProcessor(ConfigurableApplicationContext context) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("Registering bean definition registry post processor for context [" + context + "]"));
            }
            return new HookRegisteringBeanDefinitionRegistryPostProcessor(context);
        }

        @PreDestroy
        public void cleanupHooks() {
            if (log.isTraceEnabled()) {
                log.trace((Object)"Cleaning up hooks");
            }
            Hooks.resetOnEachOperator((String)SLEUTH_TRACE_REACTOR_KEY);
            Schedulers.removeExecutorServiceDecorator((String)TraceReactorAutoConfiguration.SLEUTH_REACTOR_EXECUTOR_SERVICE_KEY);
        }
    }
}

