/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.reactor;

import java.util.concurrent.ExecutorService;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.cloud.sleuth.instrument.async.TraceableScheduledExecutorService;
import org.springframework.cloud.sleuth.instrument.reactor.ReactorSleuth;
import org.springframework.cloud.sleuth.instrument.reactor.TraceReactorAutoConfiguration;
import org.springframework.context.ConfigurableApplicationContext;
import reactor.core.publisher.Hooks;
import reactor.core.scheduler.Schedulers;

class HookRegisteringBeanDefinitionRegistryPostProcessor
implements BeanDefinitionRegistryPostProcessor {
    private final ConfigurableApplicationContext context;

    HookRegisteringBeanDefinitionRegistryPostProcessor(ConfigurableApplicationContext context) {
        this.context = context;
    }

    public void postProcessBeanDefinitionRegistry(BeanDefinitionRegistry registry) throws BeansException {
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        this.setupHooks((BeanFactory)beanFactory);
    }

    void setupHooks(BeanFactory beanFactory) {
        Hooks.onEachOperator((String)TraceReactorAutoConfiguration.TraceReactorConfiguration.SLEUTH_TRACE_REACTOR_KEY, ReactorSleuth.scopePassingSpanOperator((BeanFactory)this.context));
        Schedulers.setExecutorServiceDecorator((String)"sleuth", (scheduler, scheduledExecutorService) -> new TraceableScheduledExecutorService(beanFactory, (ExecutorService)scheduledExecutorService));
    }
}

