/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.zuul;

import brave.http.HttpTracing;
import com.netflix.zuul.ZuulFilter;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.cloud.sleuth.instrument.web.TraceWebServletAutoConfiguration;
import org.springframework.cloud.sleuth.instrument.zuul.TracePostZuulFilter;
import org.springframework.cloud.sleuth.instrument.zuul.TraceZuulHandlerMappingBeanPostProcessor;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(value={"spring.sleuth.zuul.enabled"}, matchIfMissing=true)
@ConditionalOnWebApplication
@ConditionalOnClass(value={ZuulFilter.class})
@ConditionalOnBean(value={HttpTracing.class})
@AutoConfigureAfter(value={TraceWebServletAutoConfiguration.class})
public class TraceZuulAutoConfiguration {
    @Bean
    static TraceZuulHandlerMappingBeanPostProcessor traceHandlerMappingBeanPostProcessor(BeanFactory beanFactory) {
        return new TraceZuulHandlerMappingBeanPostProcessor(beanFactory);
    }

    @Bean
    TracePostZuulFilter tracePostZuulFilter(HttpTracing httpTracing) {
        return new TracePostZuulFilter(httpTracing);
    }
}

