/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.web.client.feign;

import brave.Span;
import brave.Tracer;
import brave.http.HttpClientAdapter;
import brave.http.HttpClientHandler;
import brave.http.HttpTracing;
import brave.propagation.Propagation;
import brave.propagation.TraceContext;
import feign.Client;
import feign.Request;
import feign.Response;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

final class TracingFeignClient
implements Client {
    private static final Log log = LogFactory.getLog(TracingFeignClient.class);
    static final Propagation.Setter<Map<String, Collection<String>>, String> SETTER = new Propagation.Setter<Map<String, Collection<String>>, String>(){

        public void put(Map<String, Collection<String>> carrier, String key, String value) {
            if (!carrier.containsKey(key)) {
                carrier.put(key, Collections.singletonList(value));
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Added key [" + key + "] and header value [" + value + "]"));
                }
            } else if (log.isTraceEnabled()) {
                log.trace((Object)("Key [" + key + "] already there in the headers"));
            }
        }

        public String toString() {
            return "Map::set";
        }
    };
    final Tracer tracer;
    final Client delegate;
    final HttpClientHandler<Request, Response> handler;
    final TraceContext.Injector<Map<String, Collection<String>>> injector;

    TracingFeignClient(HttpTracing httpTracing, Client delegate) {
        this.tracer = httpTracing.tracing().tracer();
        this.handler = HttpClientHandler.create((HttpTracing)httpTracing, (HttpClientAdapter)new HttpAdapter());
        this.injector = httpTracing.tracing().propagation().injector(SETTER);
        this.delegate = delegate;
    }

    static Client create(HttpTracing httpTracing, Client delegate) {
        return new TracingFeignClient(httpTracing, delegate);
    }

    /*
     * Exception decompiling
     */
    public Response execute(Request request, Request.Options options) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    Span handleSend(Map<String, Collection<String>> headers, Request request, Span clientSpan) {
        if (clientSpan != null) {
            return this.handler.handleSend(this.injector, headers, (Object)request, clientSpan);
        }
        return this.handler.handleSend(this.injector, headers, (Object)request);
    }

    void handleReceive(Span span, Response response, Throwable error) {
        this.handler.handleReceive((Object)response, error, span);
    }

    private Request modifiedRequest(Request request, Map<String, Collection<String>> headers) {
        String method = request.method();
        String url = request.url();
        byte[] body = request.body();
        Charset charset = request.charset();
        return Request.create((String)method, (String)url, headers, (byte[])body, (Charset)charset);
    }

    static final class HttpAdapter
    extends HttpClientAdapter<Request, Response> {
        HttpAdapter() {
        }

        public String method(Request request) {
            return request.method();
        }

        public String url(Request request) {
            return request.url();
        }

        public String requestHeader(Request request, String name) {
            Collection result = (Collection)request.headers().get(name);
            return result != null && result.iterator().hasNext() ? (String)result.iterator().next() : null;
        }

        public Integer statusCode(Response response) {
            return response.status();
        }
    }
}

