/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.web.client.feign;

import brave.http.HttpTracing;
import feign.Client;
import feign.Feign;
import feign.okhttp.OkHttpClient;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.openfeign.FeignAutoConfiguration;
import org.springframework.cloud.openfeign.FeignContext;
import org.springframework.cloud.sleuth.instrument.hystrix.SleuthHystrixAutoConfiguration;
import org.springframework.cloud.sleuth.instrument.web.TraceHttpAutoConfiguration;
import org.springframework.cloud.sleuth.instrument.web.client.feign.FeignContextBeanPostProcessor;
import org.springframework.cloud.sleuth.instrument.web.client.feign.OkHttpFeignClientBeanPostProcessor;
import org.springframework.cloud.sleuth.instrument.web.client.feign.SleuthFeignBuilder;
import org.springframework.cloud.sleuth.instrument.web.client.feign.SleuthHystrixFeignBuilder;
import org.springframework.cloud.sleuth.instrument.web.client.feign.TraceFeignAspect;
import org.springframework.cloud.sleuth.instrument.web.client.feign.TraceFeignObjectWrapper;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Scope;

@Configuration
@ConditionalOnProperty(value={"spring.sleuth.feign.enabled"}, matchIfMissing=true)
@ConditionalOnClass(value={Client.class, FeignContext.class})
@ConditionalOnBean(value={HttpTracing.class})
@AutoConfigureBefore(value={FeignAutoConfiguration.class})
@AutoConfigureAfter(value={SleuthHystrixAutoConfiguration.class, TraceHttpAutoConfiguration.class})
public class TraceFeignClientAutoConfiguration {
    @Bean
    @Scope(value="prototype")
    @ConditionalOnClass(name={"com.netflix.hystrix.HystrixCommand", "feign.hystrix.HystrixFeign"})
    @ConditionalOnProperty(name={"feign.hystrix.enabled"}, havingValue="true")
    Feign.Builder feignHystrixBuilder(BeanFactory beanFactory) {
        return SleuthHystrixFeignBuilder.builder(beanFactory);
    }

    @Bean
    @ConditionalOnMissingBean
    @Scope(value="prototype")
    @ConditionalOnProperty(name={"feign.hystrix.enabled"}, havingValue="false", matchIfMissing=true)
    Feign.Builder feignBuilder(BeanFactory beanFactory) {
        return SleuthFeignBuilder.builder(beanFactory);
    }

    @Bean
    TraceFeignObjectWrapper traceFeignObjectWrapper(BeanFactory beanFactory) {
        return new TraceFeignObjectWrapper(beanFactory);
    }

    @Bean
    TraceFeignAspect traceFeignAspect(BeanFactory beanFactory) {
        return new TraceFeignAspect(beanFactory);
    }

    @Configuration
    @ConditionalOnClass(value={OkHttpClient.class})
    protected static class OkHttpClientFeignBeanPostProcessorConfiguration {
        protected OkHttpClientFeignBeanPostProcessorConfiguration() {
        }

        @Bean
        static OkHttpFeignClientBeanPostProcessor okHttpFeignClientBeanPostProcessor(BeanFactory beanFactory) {
            return new OkHttpFeignClientBeanPostProcessor(beanFactory);
        }
    }

    @Configuration
    @ConditionalOnProperty(name={"spring.sleuth.feign.processor.enabled"}, matchIfMissing=true)
    protected static class FeignBeanPostProcessorConfiguration {
        protected FeignBeanPostProcessorConfiguration() {
        }

        @Bean
        static FeignContextBeanPostProcessor feignContextBeanPostProcessor(BeanFactory beanFactory) {
            return new FeignContextBeanPostProcessor(beanFactory);
        }
    }
}

