/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.web.client;

import brave.Span;
import brave.http.HttpTracing;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.gateway.filter.headers.HttpHeadersFilter;
import org.springframework.cloud.sleuth.instrument.web.client.AbstractHttpHeadersFilter;
import org.springframework.http.HttpHeaders;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.web.server.ServerWebExchange;

final class TraceRequestHttpHeadersFilter
extends AbstractHttpHeadersFilter {
    private static final Log log = LogFactory.getLog(TraceRequestHttpHeadersFilter.class);

    private TraceRequestHttpHeadersFilter(HttpTracing httpTracing) {
        super(httpTracing);
    }

    static HttpHeadersFilter create(HttpTracing httpTracing) {
        return new TraceRequestHttpHeadersFilter(httpTracing);
    }

    public HttpHeaders filter(HttpHeaders input, ServerWebExchange exchange) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Will instrument the HTTP request headers");
        }
        ServerHttpRequest.Builder builder = exchange.getRequest().mutate();
        Span span = this.handler.handleSend(this.injector, (Object)builder);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Client span  " + span + " created for the request. New headers are " + builder.build().getHeaders().toSingleValueMap()));
        }
        exchange.getAttributes().put(SPAN_ATTRIBUTE, span);
        HttpHeaders headersWithInput = new HttpHeaders();
        headersWithInput.setAll(input.toSingleValueMap());
        headersWithInput.setAll(builder.build().getHeaders().toSingleValueMap());
        return headersWithInput;
    }

    public boolean supports(HttpHeadersFilter.Type type) {
        return type.equals((Object)HttpHeadersFilter.Type.REQUEST);
    }
}

