/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.async;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.function.Supplier;
import org.aopalliance.aop.Advice;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.aop.framework.AopConfigException;
import org.springframework.aop.framework.ProxyFactoryBean;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.cloud.sleuth.instrument.async.ExecutorMethodInterceptor;
import org.springframework.cloud.sleuth.instrument.async.LazyTraceAsyncTaskExecutor;
import org.springframework.cloud.sleuth.instrument.async.LazyTraceExecutor;
import org.springframework.cloud.sleuth.instrument.async.LazyTraceThreadPoolTaskExecutor;
import org.springframework.cloud.sleuth.instrument.async.SleuthAsyncProperties;
import org.springframework.cloud.sleuth.instrument.async.TraceableExecutorService;
import org.springframework.core.task.AsyncTaskExecutor;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.util.ReflectionUtils;

class ExecutorBeanPostProcessor
implements BeanPostProcessor {
    private static final Log log = LogFactory.getLog(ExecutorBeanPostProcessor.class);
    private final BeanFactory beanFactory;
    private SleuthAsyncProperties sleuthAsyncProperties;

    ExecutorBeanPostProcessor(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof ThreadPoolTaskExecutor && !(bean instanceof LazyTraceThreadPoolTaskExecutor)) {
            if (this.isProxyNeeded(beanName)) {
                return this.wrapThreadPoolTaskExecutor(bean);
            }
            log.info((Object)("Not instrumenting bean " + beanName));
        } else if (bean instanceof ExecutorService && !(bean instanceof TraceableExecutorService)) {
            if (this.isProxyNeeded(beanName)) {
                return this.wrapExecutorService(bean);
            }
            log.info((Object)("Not instrumenting bean " + beanName));
        } else if (bean instanceof AsyncTaskExecutor && !(bean instanceof LazyTraceAsyncTaskExecutor)) {
            if (this.isProxyNeeded(beanName)) {
                return this.wrapAsyncTaskExecutor(bean);
            }
            log.info((Object)("Not instrumenting bean " + beanName));
        } else if (bean instanceof Executor && !(bean instanceof LazyTraceExecutor)) {
            return this.wrapExecutor(bean);
        }
        return bean;
    }

    private Object wrapExecutor(Object bean) {
        Method execute = ReflectionUtils.findMethod(bean.getClass(), (String)"execute", (Class[])new Class[]{Runnable.class});
        boolean methodFinal = Modifier.isFinal(execute.getModifiers());
        boolean classFinal = Modifier.isFinal(bean.getClass().getModifiers());
        boolean cglibProxy = !methodFinal && !classFinal;
        Executor executor = (Executor)bean;
        try {
            return this.createProxy(bean, cglibProxy, (Advice)new ExecutorMethodInterceptor<Executor>(executor, this.beanFactory));
        }
        catch (AopConfigException ex) {
            if (cglibProxy) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Exception occurred while trying to create a proxy, falling back to JDK proxy", (Throwable)ex);
                }
                return this.createProxy(bean, false, (Advice)new ExecutorMethodInterceptor<Executor>(executor, this.beanFactory));
            }
            throw ex;
        }
    }

    private Object wrapThreadPoolTaskExecutor(Object bean) {
        boolean classFinal = Modifier.isFinal(bean.getClass().getModifiers());
        boolean cglibProxy = !classFinal;
        ThreadPoolTaskExecutor executor = (ThreadPoolTaskExecutor)bean;
        return this.createThreadPoolTaskExecutorProxy(bean, cglibProxy, executor);
    }

    private Object wrapExecutorService(Object bean) {
        boolean classFinal = Modifier.isFinal(bean.getClass().getModifiers());
        boolean cglibProxy = !classFinal;
        ExecutorService executor = (ExecutorService)bean;
        return this.createExecutorServiceProxy(bean, cglibProxy, executor);
    }

    private Object wrapAsyncTaskExecutor(Object bean) {
        boolean classFinal = Modifier.isFinal(bean.getClass().getModifiers());
        boolean cglibProxy = !classFinal;
        AsyncTaskExecutor executor = (AsyncTaskExecutor)bean;
        return this.createAsyncTaskExecutorProxy(bean, cglibProxy, executor);
    }

    boolean isProxyNeeded(String beanName) {
        SleuthAsyncProperties sleuthAsyncProperties = this.asyncConfigurationProperties();
        return !sleuthAsyncProperties.getIgnoredBeans().contains(beanName);
    }

    Object createThreadPoolTaskExecutorProxy(Object bean, boolean cglibProxy, ThreadPoolTaskExecutor executor) {
        return this.getProxiedObject(bean, cglibProxy, (Executor)executor, () -> new LazyTraceThreadPoolTaskExecutor(this.beanFactory, executor));
    }

    Object createExecutorServiceProxy(Object bean, boolean cglibProxy, ExecutorService executor) {
        return this.getProxiedObject(bean, cglibProxy, executor, () -> new TraceableExecutorService(this.beanFactory, executor));
    }

    Object createAsyncTaskExecutorProxy(Object bean, boolean cglibProxy, AsyncTaskExecutor executor) {
        return this.getProxiedObject(bean, cglibProxy, (Executor)executor, () -> new LazyTraceAsyncTaskExecutor(this.beanFactory, executor));
    }

    private Object getProxiedObject(Object bean, boolean cglibProxy, Executor executor, final Supplier<Executor> supplier) {
        ProxyFactoryBean factory = new ProxyFactoryBean();
        factory.setProxyTargetClass(cglibProxy);
        factory.addAdvice((Advice)new ExecutorMethodInterceptor<Executor>(executor, this.beanFactory){

            @Override
            <T extends Executor> T executor(BeanFactory beanFactory, T executor) {
                return (T)((Executor)supplier.get());
            }
        });
        factory.setTarget(bean);
        try {
            return this.getObject(factory);
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Exception occurred while trying to get a proxy. Will fallback to a different implementation", (Throwable)e);
            }
            return supplier.get();
        }
    }

    Object getObject(ProxyFactoryBean factory) {
        return factory.getObject();
    }

    Object createProxy(Object bean, boolean cglibProxy, Advice advice) {
        ProxyFactoryBean factory = new ProxyFactoryBean();
        factory.setProxyTargetClass(cglibProxy);
        factory.addAdvice(advice);
        factory.setTarget(bean);
        return this.getObject(factory);
    }

    private SleuthAsyncProperties asyncConfigurationProperties() {
        if (this.sleuthAsyncProperties == null) {
            this.sleuthAsyncProperties = (SleuthAsyncProperties)this.beanFactory.getBean(SleuthAsyncProperties.class);
        }
        return this.sleuthAsyncProperties;
    }
}

