/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.log;

import brave.propagation.CurrentTraceContext;
import org.slf4j.MDC;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.sleuth.autoconfig.TraceAutoConfiguration;
import org.springframework.cloud.sleuth.log.SleuthSlf4jProperties;
import org.springframework.cloud.sleuth.log.Slf4jCurrentTraceContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(value={"spring.sleuth.enabled"}, matchIfMissing=true)
@AutoConfigureBefore(value={TraceAutoConfiguration.class})
public class SleuthLogAutoConfiguration {

    @Configuration
    @ConditionalOnClass(value={MDC.class})
    @EnableConfigurationProperties(value={SleuthSlf4jProperties.class})
    protected static class Slf4jConfiguration {
        protected Slf4jConfiguration() {
        }

        @Bean
        @ConditionalOnProperty(value={"spring.sleuth.log.slf4j.enabled"}, matchIfMissing=true)
        @ConditionalOnMissingBean
        public CurrentTraceContext slf4jSpanLogger() {
            return Slf4jCurrentTraceContext.create();
        }

        @Bean
        @ConditionalOnProperty(value={"spring.sleuth.log.slf4j.enabled"}, matchIfMissing=true)
        @ConditionalOnBean(value={CurrentTraceContext.class})
        public static BeanPostProcessor slf4jSpanLoggerBPP() {
            return new Slf4jBeanPostProcessor();
        }

        static class Slf4jBeanPostProcessor
        implements BeanPostProcessor {
            Slf4jBeanPostProcessor() {
            }

            public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
                return bean;
            }

            public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
                if (bean instanceof CurrentTraceContext && !(bean instanceof Slf4jCurrentTraceContext)) {
                    return Slf4jCurrentTraceContext.create((CurrentTraceContext)bean);
                }
                return bean;
            }
        }
    }
}

