/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.web.client.feign;

import feign.Client;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.cloud.netflix.ribbon.SpringClientFactory;
import org.springframework.cloud.openfeign.ribbon.CachingSpringLoadBalancerFactory;
import org.springframework.cloud.openfeign.ribbon.LoadBalancerFeignClient;
import org.springframework.cloud.sleuth.instrument.web.client.feign.LazyTracingFeignClient;
import org.springframework.cloud.sleuth.instrument.web.client.feign.TraceLoadBalancerFeignClient;
import org.springframework.cloud.sleuth.instrument.web.client.feign.TracingFeignClient;
import org.springframework.util.ClassUtils;

final class TraceFeignObjectWrapper {
    private final BeanFactory beanFactory;
    private CachingSpringLoadBalancerFactory cachingSpringLoadBalancerFactory;
    private Object springClientFactory;
    private static final boolean ribbonPresent = ClassUtils.isPresent((String)"org.springframework.cloud.openfeign.ribbon.LoadBalancerFeignClient", null) && ClassUtils.isPresent((String)"org.springframework.cloud.netflix.ribbon.SpringClientFactory", null);

    TraceFeignObjectWrapper(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    Object wrap(Object bean) {
        if (bean instanceof Client && !(bean instanceof TracingFeignClient)) {
            if (ribbonPresent && bean instanceof LoadBalancerFeignClient && !(bean instanceof TraceLoadBalancerFeignClient)) {
                LoadBalancerFeignClient client = (LoadBalancerFeignClient)bean;
                return new TraceLoadBalancerFeignClient((Client)new TraceFeignObjectWrapper(this.beanFactory).wrap(client.getDelegate()), this.factory(), (SpringClientFactory)this.clientFactory(), this.beanFactory);
            }
            if (ribbonPresent && bean instanceof TraceLoadBalancerFeignClient) {
                return bean;
            }
            return new LazyTracingFeignClient(this.beanFactory, (Client)bean);
        }
        return bean;
    }

    private CachingSpringLoadBalancerFactory factory() {
        if (this.cachingSpringLoadBalancerFactory == null) {
            this.cachingSpringLoadBalancerFactory = (CachingSpringLoadBalancerFactory)this.beanFactory.getBean(CachingSpringLoadBalancerFactory.class);
        }
        return this.cachingSpringLoadBalancerFactory;
    }

    private Object clientFactory() {
        if (this.springClientFactory == null) {
            this.springClientFactory = this.beanFactory.getBean(SpringClientFactory.class);
        }
        return this.springClientFactory;
    }
}

