/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.web.client.feign;

import brave.http.HttpTracing;
import feign.Client;
import feign.Feign;
import feign.Retryer;
import feign.hystrix.HystrixFeign;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.cloud.sleuth.instrument.web.client.feign.LazyClient;
import org.springframework.cloud.sleuth.instrument.web.client.feign.TracingFeignClient;

final class SleuthHystrixFeignBuilder {
    private SleuthHystrixFeignBuilder() {
    }

    static Feign.Builder builder(BeanFactory beanFactory) {
        return HystrixFeign.builder().retryer(Retryer.NEVER_RETRY).client(SleuthHystrixFeignBuilder.client(beanFactory));
    }

    private static Client client(BeanFactory beanFactory) {
        try {
            Client client = (Client)beanFactory.getBean(Client.class);
            return new LazyClient(beanFactory, client);
        }
        catch (BeansException e) {
            return TracingFeignClient.create((HttpTracing)beanFactory.getBean(HttpTracing.class), (Client)new Client.Default(null, null));
        }
    }
}

