/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.web.client;

import brave.Span;
import brave.Tracer;
import brave.http.HttpClientAdapter;
import brave.http.HttpClientHandler;
import brave.http.HttpTracing;
import brave.propagation.Propagation;
import brave.propagation.TraceContext;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.cookie.Cookie;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.aspectj.lang.ProceedingJoinPoint;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.ipc.netty.NettyContext;
import reactor.ipc.netty.NettyOutbound;
import reactor.ipc.netty.NettyPipeline;
import reactor.ipc.netty.channel.data.FileChunkedStrategy;
import reactor.ipc.netty.http.client.HttpClientRequest;
import reactor.ipc.netty.http.client.HttpClientResponse;
import reactor.ipc.netty.http.websocket.WebsocketOutbound;

class TracingHttpClientInstrumentation {
    private static final Log log = LogFactory.getLog(TracingHttpClientInstrumentation.class);
    static final Propagation.Setter<HttpHeaders, String> SETTER = new Propagation.Setter<HttpHeaders, String>(){

        public void put(HttpHeaders carrier, String key, String value) {
            if (!carrier.contains(key)) {
                carrier.add(key, (Object)value);
            }
        }

        public String toString() {
            return "HttpHeaders::add";
        }
    };
    static final Propagation.Getter<HttpHeaders, String> GETTER = new Propagation.Getter<HttpHeaders, String>(){

        public String get(HttpHeaders carrier, String key) {
            return carrier.get(key);
        }

        public String toString() {
            return "HttpHeaders::get";
        }
    };
    final Tracer tracer;
    final HttpClientHandler<HttpClientRequest, HttpClientResponse> handler;
    final TraceContext.Injector<HttpHeaders> injector;
    final HttpTracing httpTracing;

    static TracingHttpClientInstrumentation create(HttpTracing httpTracing) {
        return new TracingHttpClientInstrumentation(httpTracing);
    }

    TracingHttpClientInstrumentation(HttpTracing httpTracing) {
        this.tracer = httpTracing.tracing().tracer();
        this.handler = HttpClientHandler.create((HttpTracing)httpTracing, (HttpClientAdapter)new HttpAdapter());
        this.injector = httpTracing.tracing().propagation().injector(SETTER);
        this.httpTracing = httpTracing;
    }

    Mono<HttpClientResponse> wrapHttpClientRequestSending(ProceedingJoinPoint pjp, HttpMethod method, String url, Function<? super HttpClientRequest, ? extends Publisher<Void>> handler) throws Throwable {
        Span currentSpan = this.tracer.currentSpan();
        AtomicReference span = new AtomicReference();
        Function<HttpClientRequest, Publisher> combinedFunction = req -> {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        };
        Mono responseMono = (Mono)pjp.proceed(new Object[]{method, url, combinedFunction});
        return responseMono.doOnSuccessOrError((httpClientResponse, throwable) -> {
            try (Tracer.SpanInScope ws = this.tracer.withSpanInScope((Span)span.get());){
                this.handler.handleReceive(httpClientResponse, throwable, (Span)span.get());
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Setting client sent spans");
                }
            }
        });
    }

    private Publisher<Void> handle(Function<? super HttpClientRequest, ? extends Publisher<Void>> handler, HttpClientRequest req) {
        if (handler != null) {
            return handler.apply((HttpClientRequest)req);
        }
        return req;
    }

    private static /* synthetic */ void lambda$null$0(HttpHeaders addedHeaders, Map.Entry header) {
        addedHeaders.remove((String)header.getKey());
    }

    static final class HttpAdapter
    extends HttpClientAdapter<HttpClientRequest, HttpClientResponse> {
        HttpAdapter() {
        }

        public String method(HttpClientRequest request) {
            return request.method().name();
        }

        public String url(HttpClientRequest request) {
            return request.uri();
        }

        public String requestHeader(HttpClientRequest request, String name) {
            String result = request.requestHeaders().get(name);
            return result != null ? result.toString() : "";
        }

        public Integer statusCode(HttpClientResponse response) {
            return response.status().code();
        }
    }

    static class TracedHttpClientRequest
    implements HttpClientRequest {
        private HttpClientRequest delegate;
        private final HttpHeaders addedHeaders;

        TracedHttpClientRequest(HttpClientRequest delegate, HttpHeaders addedHeaders) {
            this.delegate = delegate;
            this.addedHeaders = addedHeaders;
        }

        public HttpClientRequest addCookie(Cookie cookie) {
            this.delegate = this.delegate.addCookie(cookie);
            return this;
        }

        public HttpClientRequest addHeader(CharSequence name, CharSequence value) {
            this.delegate = this.delegate.addHeader(name, value);
            return this;
        }

        public HttpClientRequest context(Consumer<NettyContext> contextCallback) {
            this.delegate = this.delegate.context(contextCallback);
            return this;
        }

        public HttpClientRequest chunkedTransfer(boolean chunked) {
            this.delegate = this.delegate.chunkedTransfer(chunked);
            return this;
        }

        public HttpClientRequest options(Consumer<? super NettyPipeline.SendOptions> configurator) {
            this.delegate = this.delegate.options(configurator);
            return this;
        }

        public HttpClientRequest followRedirect() {
            this.delegate = this.delegate.followRedirect();
            return this;
        }

        public HttpClientRequest failOnClientError(boolean shouldFail) {
            this.delegate = this.delegate.failOnClientError(shouldFail);
            return this;
        }

        public HttpClientRequest failOnServerError(boolean shouldFail) {
            this.delegate = this.delegate.failOnServerError(shouldFail);
            return this;
        }

        public boolean hasSentHeaders() {
            return this.delegate.hasSentHeaders();
        }

        public HttpClientRequest header(CharSequence name, CharSequence value) {
            this.delegate = this.delegate.header(name, value);
            return this;
        }

        public HttpClientRequest headers(HttpHeaders headers) {
            HttpHeaders copy = headers.copy();
            copy.add(this.addedHeaders);
            this.delegate = this.delegate.headers(copy);
            return this;
        }

        public boolean isFollowRedirect() {
            return this.delegate.isFollowRedirect();
        }

        public HttpClientRequest keepAlive(boolean keepAlive) {
            this.delegate = this.delegate.keepAlive(keepAlive);
            return this;
        }

        public HttpClientRequest onWriteIdle(long idleTimeout, Runnable onWriteIdle) {
            this.delegate = this.delegate.onWriteIdle(idleTimeout, onWriteIdle);
            return this;
        }

        public String[] redirectedFrom() {
            return this.delegate.redirectedFrom();
        }

        public HttpHeaders requestHeaders() {
            return this.delegate.requestHeaders();
        }

        public Mono<Void> send() {
            return this.delegate.send();
        }

        public Flux<Long> sendForm(Consumer<HttpClientRequest.Form> formCallback) {
            return this.delegate.sendForm(formCallback);
        }

        public NettyOutbound sendHeaders() {
            return this.delegate.sendHeaders();
        }

        public WebsocketOutbound sendWebsocket() {
            return this.delegate.sendWebsocket();
        }

        public WebsocketOutbound sendWebsocket(String subprotocols) {
            return this.delegate.sendWebsocket(subprotocols);
        }

        public ByteBufAllocator alloc() {
            return this.delegate.alloc();
        }

        public NettyContext context() {
            return this.delegate.context();
        }

        public FileChunkedStrategy getFileChunkedStrategy() {
            return this.delegate.getFileChunkedStrategy();
        }

        public Mono<Void> neverComplete() {
            return this.delegate.neverComplete();
        }

        public NettyOutbound send(Publisher<? extends ByteBuf> dataStream) {
            return this.delegate.send(dataStream);
        }

        public NettyOutbound sendByteArray(Publisher<? extends byte[]> dataStream) {
            return this.delegate.sendByteArray(dataStream);
        }

        public NettyOutbound sendFile(Path file) {
            return this.delegate.sendFile(file);
        }

        public NettyOutbound sendFile(Path file, long position, long count) {
            return this.delegate.sendFile(file, position, count);
        }

        public NettyOutbound sendFileChunked(Path file, long position, long count) {
            return this.delegate.sendFileChunked(file, position, count);
        }

        public NettyOutbound sendGroups(Publisher<? extends Publisher<? extends ByteBuf>> dataStreams) {
            return this.delegate.sendGroups(dataStreams);
        }

        public NettyOutbound sendObject(Publisher<?> dataStream) {
            return this.delegate.sendObject(dataStream);
        }

        public NettyOutbound sendObject(Object msg) {
            return this.delegate.sendObject(msg);
        }

        public NettyOutbound sendString(Publisher<? extends String> dataStream) {
            return this.delegate.sendString(dataStream);
        }

        public NettyOutbound sendString(Publisher<? extends String> dataStream, Charset charset) {
            return this.delegate.sendString(dataStream, charset);
        }

        public void subscribe(Subscriber<? super Void> s) {
            this.delegate.subscribe(s);
        }

        public Mono<Void> then() {
            return this.delegate.then();
        }

        public NettyOutbound then(Publisher<Void> other) {
            return this.delegate.then(other);
        }

        public Map<CharSequence, Set<Cookie>> cookies() {
            return this.delegate.cookies();
        }

        public boolean isKeepAlive() {
            return this.delegate.isKeepAlive();
        }

        public boolean isWebsocket() {
            return this.delegate.isWebsocket();
        }

        public HttpMethod method() {
            return this.delegate.method();
        }

        public String path() {
            return this.delegate.path();
        }

        public String uri() {
            return this.delegate.uri();
        }

        public HttpVersion version() {
            return this.delegate.version();
        }
    }
}

