/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.web.client;

import brave.http.HttpTracing;
import brave.spring.web.TracingAsyncClientHttpRequestInterceptor;
import java.util.ArrayList;
import java.util.Collection;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.sleuth.instrument.web.TraceWebServletAutoConfiguration;
import org.springframework.cloud.sleuth.instrument.web.client.SleuthWebClientEnabled;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.client.AsyncRestTemplate;

@Configuration
@SleuthWebClientEnabled
@ConditionalOnProperty(value={"spring.sleuth.web.async.client.enabled"}, matchIfMissing=true)
@ConditionalOnClass(value={AsyncRestTemplate.class})
@ConditionalOnBean(value={HttpTracing.class})
@AutoConfigureAfter(value={TraceWebServletAutoConfiguration.class})
public class TraceWebAsyncClientAutoConfiguration {

    @ConditionalOnBean(value={AsyncRestTemplate.class})
    static class AsyncRestTemplateConfig {
        AsyncRestTemplateConfig() {
        }

        @Bean
        public TracingAsyncClientHttpRequestInterceptor asyncTracingClientHttpRequestInterceptor(HttpTracing httpTracing) {
            return (TracingAsyncClientHttpRequestInterceptor)TracingAsyncClientHttpRequestInterceptor.create((HttpTracing)httpTracing);
        }

        @Configuration
        protected static class TraceInterceptorConfiguration {
            @Autowired(required=false)
            private Collection<AsyncRestTemplate> restTemplates;
            @Autowired
            private TracingAsyncClientHttpRequestInterceptor clientInterceptor;

            protected TraceInterceptorConfiguration() {
            }

            @PostConstruct
            public void init() {
                if (this.restTemplates != null) {
                    for (AsyncRestTemplate restTemplate : this.restTemplates) {
                        ArrayList<TracingAsyncClientHttpRequestInterceptor> interceptors = new ArrayList<TracingAsyncClientHttpRequestInterceptor>(restTemplate.getInterceptors());
                        interceptors.add(this.clientInterceptor);
                        restTemplate.setInterceptors(interceptors);
                    }
                }
            }
        }
    }
}

