/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.web.client;

import brave.Span;
import brave.Tracer;
import brave.http.HttpClientAdapter;
import brave.http.HttpClientHandler;
import brave.http.HttpTracing;
import brave.propagation.Propagation;
import brave.propagation.TraceContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.web.client.RestClientException;
import org.springframework.web.reactive.function.client.ClientRequest;
import org.springframework.web.reactive.function.client.ClientResponse;
import org.springframework.web.reactive.function.client.ExchangeFilterFunction;
import org.springframework.web.reactive.function.client.ExchangeFunction;
import reactor.core.publisher.Mono;
import reactor.util.context.Context;

class TraceExchangeFilterFunction
implements ExchangeFilterFunction {
    private static final Log log = LogFactory.getLog(TraceExchangeFilterFunction.class);
    private static final String CLIENT_SPAN_KEY = "sleuth.webclient.clientSpan";
    static final Propagation.Setter<ClientRequest.Builder, String> SETTER = new Propagation.Setter<ClientRequest.Builder, String>(){

        public void put(ClientRequest.Builder carrier, String key, String value) {
            carrier.header(key, new String[]{value});
        }

        public String toString() {
            return "ClientRequest.Builder::header";
        }
    };
    static final Propagation.Getter<ClientRequest, String> GETTER = new Propagation.Getter<ClientRequest, String>(){

        public String get(ClientRequest carrier, String key) {
            return carrier.headers().getFirst(key);
        }

        public String toString() {
            return "HttpHeaders::getFirst";
        }
    };
    final BeanFactory beanFactory;
    Tracer tracer;
    HttpTracing httpTracing;
    HttpClientHandler<ClientRequest, ClientResponse> handler;
    TraceContext.Injector<ClientRequest.Builder> injector;

    public static ExchangeFilterFunction create(BeanFactory beanFactory) {
        return new TraceExchangeFilterFunction(beanFactory);
    }

    TraceExchangeFilterFunction(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    public Mono<ClientResponse> filter(ClientRequest request, ExchangeFunction next) {
        ClientRequest.Builder builder = ClientRequest.from((ClientRequest)request);
        Mono exchange = Mono.defer(() -> next.exchange(builder.build())).cast(Object.class).onErrorResume(Mono::just).zipWith(Mono.subscriberContext()).flatMap(anyAndContext -> {
            Object any = anyAndContext.getT1();
            Span clientSpan = (Span)((Context)anyAndContext.getT2()).get((Object)CLIENT_SPAN_KEY);
            Tracer.SpanInScope ws = this.tracer().withSpanInScope(clientSpan);
            Mono continuation = any instanceof Throwable ? Mono.error((Throwable)((Throwable)any)) : Mono.just((Object)((ClientResponse)any));
            return continuation.doAfterSuccessOrError((clientResponse, throwable1) -> {
                boolean error;
                Throwable throwable = throwable1;
                if (clientResponse == null || clientResponse.statusCode() == null) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("No response was returned. Will close the span [" + clientSpan + "]"));
                    }
                    this.handleReceive(clientSpan, ws, (ClientResponse)clientResponse, throwable);
                    return;
                }
                boolean bl = error = clientResponse.statusCode().is4xxClientError() || clientResponse.statusCode().is5xxServerError();
                if (error) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Non positive status code was returned from the call. Will close the span [" + clientSpan + "]"));
                    }
                    throwable = new RestClientException("Status code of the response is [" + clientResponse.statusCode().value() + "] and the reason is [" + clientResponse.statusCode().getReasonPhrase() + "]");
                }
                this.handleReceive(clientSpan, ws, (ClientResponse)clientResponse, throwable);
            });
        }).subscriberContext(c -> {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Instrumenting WebClient call");
            }
            Span parent = (Span)c.getOrDefault(Span.class, null);
            Span clientSpan = this.handler().handleSend(this.injector(), (Object)builder, (Object)request, this.tracer().nextSpan());
            if (log.isDebugEnabled()) {
                log.debug((Object)("Handled send of " + clientSpan));
            }
            if (parent == null) {
                c = c.put(Span.class, (Object)clientSpan);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Reactor Context got injected with the client span " + clientSpan));
                }
            }
            return c.put((Object)CLIENT_SPAN_KEY, (Object)clientSpan);
        });
        return exchange;
    }

    private void handleReceive(Span clientSpan, Tracer.SpanInScope ws, ClientResponse clientResponse, Throwable throwable) {
        this.handler().handleReceive((Object)clientResponse, throwable, clientSpan);
        ws.close();
    }

    HttpClientHandler<ClientRequest, ClientResponse> handler() {
        if (this.handler == null) {
            this.handler = HttpClientHandler.create((HttpTracing)((HttpTracing)this.beanFactory.getBean(HttpTracing.class)), (HttpClientAdapter)new HttpAdapter());
        }
        return this.handler;
    }

    Tracer tracer() {
        if (this.tracer == null) {
            this.tracer = this.httpTracing().tracing().tracer();
        }
        return this.tracer;
    }

    HttpTracing httpTracing() {
        if (this.httpTracing == null) {
            this.httpTracing = (HttpTracing)this.beanFactory.getBean(HttpTracing.class);
        }
        return this.httpTracing;
    }

    TraceContext.Injector<ClientRequest.Builder> injector() {
        if (this.injector == null) {
            this.injector = ((HttpTracing)this.beanFactory.getBean(HttpTracing.class)).tracing().propagation().injector(SETTER);
        }
        return this.injector;
    }

    static final class HttpAdapter
    extends HttpClientAdapter<ClientRequest, ClientResponse> {
        HttpAdapter() {
        }

        public String method(ClientRequest request) {
            return request.method().name();
        }

        public String url(ClientRequest request) {
            return request.url().toString();
        }

        public String requestHeader(ClientRequest request, String name) {
            String result = request.headers().getFirst(name);
            return result != null ? result.toString() : null;
        }

        public Integer statusCode(ClientResponse response) {
            return response.statusCode().value();
        }
    }
}

