/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.web;

import brave.Span;
import brave.Tracer;
import brave.http.HttpServerAdapter;
import brave.http.HttpServerHandler;
import brave.http.HttpTracing;
import brave.propagation.Propagation;
import brave.propagation.TraceContext;
import brave.propagation.TraceContextOrSamplingFlags;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.core.Ordered;
import org.springframework.http.HttpHeaders;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.http.server.reactive.ServerHttpResponseDecorator;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.reactive.HandlerMapping;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilter;
import org.springframework.web.server.WebFilterChain;
import reactor.core.publisher.Mono;
import reactor.util.context.Context;

public final class TraceWebFilter
implements WebFilter,
Ordered {
    private static final Log log = LogFactory.getLog(TraceWebFilter.class);
    private static final String STATUS_CODE_KEY = "http.status_code";
    static final String MVC_CONTROLLER_CLASS_KEY = "mvc.controller.class";
    static final String MVC_CONTROLLER_METHOD_KEY = "mvc.controller.method";
    protected static final String TRACE_REQUEST_ATTR = TraceWebFilter.class.getName() + ".TRACE";
    private static final String TRACE_SPAN_WITHOUT_PARENT = TraceWebFilter.class.getName() + ".SPAN_WITH_NO_PARENT";
    public static final int ORDER = -2147483643;
    static final Propagation.Getter<HttpHeaders, String> GETTER = new Propagation.Getter<HttpHeaders, String>(){

        public String get(HttpHeaders carrier, String key) {
            return carrier.getFirst(key);
        }

        public String toString() {
            return "HttpHeaders::getFirst";
        }
    };
    Tracer tracer;
    HttpServerHandler<ServerHttpRequest, ServerHttpResponse> handler;
    TraceContext.Extractor<HttpHeaders> extractor;
    private final BeanFactory beanFactory;

    public static WebFilter create(BeanFactory beanFactory) {
        return new TraceWebFilter(beanFactory);
    }

    TraceWebFilter(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    HttpServerHandler<ServerHttpRequest, ServerHttpResponse> handler() {
        if (this.handler == null) {
            this.handler = HttpServerHandler.create((HttpTracing)((HttpTracing)this.beanFactory.getBean(HttpTracing.class)), (HttpServerAdapter)new HttpAdapter());
        }
        return this.handler;
    }

    Tracer tracer() {
        if (this.tracer == null) {
            this.tracer = ((HttpTracing)this.beanFactory.getBean(HttpTracing.class)).tracing().tracer();
        }
        return this.tracer;
    }

    TraceContext.Extractor<HttpHeaders> extractor() {
        if (this.extractor == null) {
            this.extractor = ((HttpTracing)this.beanFactory.getBean(HttpTracing.class)).tracing().propagation().extractor(GETTER);
        }
        return this.extractor;
    }

    public Mono<Void> filter(ServerWebExchange exchange, WebFilterChain chain) {
        if (this.tracer().currentSpan() != null) {
            this.tracer().withSpanInScope(null);
        }
        String uri = exchange.getRequest().getPath().pathWithinApplication().value();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Received a request to uri [" + uri + "]"));
        }
        Span spanFromAttribute = this.getSpanFromAttribute(exchange);
        String CONTEXT_ERROR = "sleuth.webfilter.context.error";
        return chain.filter(exchange).compose(f -> f.then(Mono.subscriberContext()).onErrorResume(t -> Mono.subscriberContext().map(c -> c.put((Object)"sleuth.webfilter.context.error", t))).flatMap(c -> {
            Mono continuation;
            Span span = this.spanFromContext((Context)c);
            Throwable t = null;
            if (c.hasKey((Object)"sleuth.webfilter.context.error")) {
                t = (Throwable)c.get((Object)"sleuth.webfilter.context.error");
                continuation = Mono.error((Throwable)t);
            } else {
                continuation = Mono.empty();
            }
            String httpRoute = null;
            Object attribute = exchange.getAttribute(HandlerMapping.BEST_MATCHING_HANDLER_ATTRIBUTE);
            if (attribute instanceof HandlerMethod) {
                HandlerMethod handlerMethod = (HandlerMethod)attribute;
                this.addClassMethodTag(handlerMethod, span);
                this.addClassNameTag(handlerMethod, span);
                Object pattern = exchange.getAttribute(HandlerMapping.BEST_MATCHING_PATTERN_ATTRIBUTE);
                httpRoute = pattern != null ? pattern.toString() : "";
            }
            this.addResponseTagsForSpanWithoutParent(exchange, exchange.getResponse(), span);
            DecoratedServerHttpResponse delegate = new DecoratedServerHttpResponse(exchange.getResponse(), exchange.getRequest().getMethodValue(), httpRoute);
            this.handler().handleSend((Object)delegate, t, span);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Handled send of " + span));
            }
            return continuation;
        }).subscriberContext(c -> {
            Span span;
            if (c.hasKey(Span.class)) {
                Span parent = (Span)c.get(Span.class);
                span = this.tracer().nextSpan(TraceContextOrSamplingFlags.create((TraceContext)parent.context())).start();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Found span in reactor context" + span));
                }
            } else {
                if (spanFromAttribute != null) {
                    span = spanFromAttribute;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Found span in attribute " + span));
                    }
                } else {
                    span = this.handler().handleReceive(this.extractor(), (Object)exchange.getRequest().getHeaders(), (Object)exchange.getRequest());
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Handled receive of span " + span));
                    }
                }
                exchange.getAttributes().put(TRACE_REQUEST_ATTR, span);
            }
            return c.put(Span.class, (Object)span);
        }));
    }

    private Span spanFromContext(Context c) {
        if (c.hasKey(Span.class)) {
            Span span = (Span)c.get(Span.class);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Found span in context " + span));
            }
            return span;
        }
        Span span = this.defaultSpan();
        if (log.isDebugEnabled()) {
            log.debug((Object)("No span found in context. Creating a new one " + span));
        }
        return span;
    }

    private Span defaultSpan() {
        return this.tracer().nextSpan().start();
    }

    private void addResponseTagsForSpanWithoutParent(ServerWebExchange exchange, ServerHttpResponse response, Span span) {
        if (this.spanWithoutParent(exchange) && response.getStatusCode() != null && span != null) {
            span.tag(STATUS_CODE_KEY, String.valueOf(response.getStatusCode().value()));
        }
    }

    private Span getSpanFromAttribute(ServerWebExchange exchange) {
        return (Span)exchange.getAttribute(TRACE_REQUEST_ATTR);
    }

    private boolean spanWithoutParent(ServerWebExchange exchange) {
        return exchange.getAttribute(TRACE_SPAN_WITHOUT_PARENT) != null;
    }

    private void addClassMethodTag(Object handler, Span span) {
        if (handler instanceof HandlerMethod) {
            String methodName = ((HandlerMethod)handler).getMethod().getName();
            span.tag(MVC_CONTROLLER_METHOD_KEY, methodName);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Adding a method tag with value [" + methodName + "] to a span " + span));
            }
        }
    }

    private void addClassNameTag(Object handler, Span span) {
        String className = handler instanceof HandlerMethod ? ((HandlerMethod)handler).getBeanType().getSimpleName() : handler.getClass().getSimpleName();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Adding a class tag with value [" + className + "] to a span " + span));
        }
        span.tag(MVC_CONTROLLER_CLASS_KEY, className);
    }

    public int getOrder() {
        return -2147483643;
    }

    static final class HttpAdapter
    extends HttpServerAdapter<ServerHttpRequest, ServerHttpResponse> {
        HttpAdapter() {
        }

        public String method(ServerHttpRequest request) {
            return request.getMethodValue();
        }

        public String url(ServerHttpRequest request) {
            return request.getURI().toString();
        }

        public String requestHeader(ServerHttpRequest request, String name) {
            String result = request.getHeaders().getFirst(name);
            return result != null ? result.toString() : null;
        }

        public Integer statusCode(ServerHttpResponse response) {
            return response.getStatusCode() != null ? Integer.valueOf(response.getStatusCode().value()) : null;
        }

        public String methodFromResponse(ServerHttpResponse response) {
            if (response instanceof DecoratedServerHttpResponse) {
                return ((DecoratedServerHttpResponse)response).method;
            }
            return null;
        }

        public String route(ServerHttpResponse response) {
            if (response instanceof DecoratedServerHttpResponse) {
                return ((DecoratedServerHttpResponse)response).httpRoute;
            }
            return null;
        }
    }

    static final class DecoratedServerHttpResponse
    extends ServerHttpResponseDecorator {
        final String method;
        final String httpRoute;

        DecoratedServerHttpResponse(ServerHttpResponse delegate, String method, String httpRoute) {
            super(delegate);
            this.method = method;
            this.httpRoute = httpRoute;
        }
    }
}

