/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.scheduling;

import brave.Span;
import brave.Tracer;
import java.util.regex.Pattern;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.springframework.cloud.sleuth.util.SpanNameUtil;

@Aspect
public class TraceSchedulingAspect {
    private static final String CLASS_KEY = "class";
    private static final String METHOD_KEY = "method";
    private final Tracer tracer;
    private final Pattern skipPattern;

    public TraceSchedulingAspect(Tracer tracer, Pattern skipPattern) {
        this.tracer = tracer;
        this.skipPattern = skipPattern;
    }

    /*
     * Loose catch block
     */
    @Around(value="execution (@org.springframework.scheduling.annotation.Scheduled  * *.*(..))")
    public Object traceBackgroundThread(ProceedingJoinPoint pjp) throws Throwable {
        if (this.skipPattern.matcher(pjp.getTarget().getClass().getName()).matches()) {
            return pjp.proceed();
        }
        String spanName = SpanNameUtil.toLowerHyphen(pjp.getSignature().getName());
        Span span = this.startOrContinueRenamedSpan(spanName);
        try {
            try (Tracer.SpanInScope ws = this.tracer.withSpanInScope(span);){
                span.tag(CLASS_KEY, pjp.getTarget().getClass().getSimpleName());
                span.tag(METHOD_KEY, pjp.getSignature().getName());
                Object object = pjp.proceed();
                return object;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            span.finish();
        }
    }

    private Span startOrContinueRenamedSpan(String spanName) {
        Span currentSpan = this.tracer.currentSpan();
        if (currentSpan != null) {
            return currentSpan.name(spanName);
        }
        return this.tracer.nextSpan().name(spanName);
    }
}

