/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.reactor;

import brave.Span;
import brave.Tracer;
import brave.Tracing;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import org.springframework.cloud.sleuth.instrument.reactor.SpanSubscription;
import reactor.util.context.Context;

final class ScopePassingSpanSubscriber<T>
extends AtomicBoolean
implements SpanSubscription<T> {
    private static final Log log = LogFactory.getLog(ScopePassingSpanSubscriber.class);
    private final Span span;
    private final Subscriber<? super T> subscriber;
    private final Context context;
    private final Tracer tracer;
    private Subscription s;

    ScopePassingSpanSubscriber(Subscriber<? super T> subscriber, Context ctx, Tracing tracing) {
        Span root;
        this.subscriber = subscriber;
        this.tracer = tracing.tracer();
        this.span = root = ctx != null ? (Span)ctx.getOrDefault(Span.class, (Object)this.tracer.currentSpan()) : null;
        Context context = ctx != null && root != null ? ctx.put(Span.class, (Object)root) : (this.context = ctx != null ? ctx : Context.empty());
        if (log.isTraceEnabled()) {
            log.trace((Object)("Root span [" + root + "], context [" + this.context + "]"));
        }
    }

    public void onSubscribe(Subscription subscription) {
        this.s = subscription;
        try (Tracer.SpanInScope inScope = this.tracer.withSpanInScope(this.span);){
            this.subscriber.onSubscribe((Subscription)this);
        }
    }

    public void request(long n) {
        try (Tracer.SpanInScope inScope = this.tracer.withSpanInScope(this.span);){
            this.s.request(n);
        }
    }

    public void cancel() {
        try (Tracer.SpanInScope inScope = this.tracer.withSpanInScope(this.span);){
            this.s.cancel();
        }
    }

    public void onNext(T o) {
        try (Tracer.SpanInScope inScope = this.tracer.withSpanInScope(this.span);){
            this.subscriber.onNext(o);
        }
    }

    public void onError(Throwable throwable) {
        this.subscriber.onError(throwable);
    }

    public void onComplete() {
        this.subscriber.onComplete();
    }

    public Context currentContext() {
        return this.context;
    }
}

