/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.reactor;

import brave.Tracing;
import java.util.function.Function;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.cloud.sleuth.instrument.reactor.ApplicationContextRefreshedListener;
import org.springframework.cloud.sleuth.instrument.reactor.LazySpanSubscriber;
import org.springframework.cloud.sleuth.instrument.reactor.ScopePassingSpanSubscriber;
import org.springframework.cloud.sleuth.instrument.reactor.SpanSubscription;
import org.springframework.cloud.sleuth.instrument.reactor.SpanSubscriptionProvider;
import reactor.core.CoreSubscriber;
import reactor.core.Scannable;
import reactor.core.publisher.ConnectableFlux;
import reactor.core.publisher.GroupedFlux;
import reactor.core.publisher.Operators;
import reactor.util.context.Context;

public abstract class ReactorSleuth {
    private static final Log log = LogFactory.getLog(ReactorSleuth.class);

    public static <T> Function<? super Publisher<T>, ? extends Publisher<T>> spanOperator(BeanFactory beanFactory) {
        return sourcePub -> {
            if (sourcePub instanceof ConnectableFlux || sourcePub instanceof GroupedFlux) {
                return sourcePub;
            }
            Function lift = Operators.lift((scannable, sub) -> {
                if (ReactorSleuth.contextRefreshed(beanFactory)) {
                    if (log.isTraceEnabled()) {
                        log.trace((Object)("Spring Context already refreshed. Creating a Sleuth span subscriber with Reactor Context [" + sub.currentContext() + "] and name [" + scannable.name() + "]"));
                    }
                    return ReactorSleuth.spanSubscriptionProvider(beanFactory, scannable, sub).get();
                }
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Spring Context is not yet refreshed, falling back to lazy span subscriber. Reactor Context is [" + sub.currentContext() + "] and name is [" + scannable.name() + "]"));
                }
                return new LazySpanSubscriber(ReactorSleuth.spanSubscriptionProvider(beanFactory, scannable, sub));
            });
            return (Publisher)lift.apply(sourcePub);
        };
    }

    private static <T> SpanSubscriptionProvider spanSubscriptionProvider(BeanFactory beanFactory, Scannable scannable, CoreSubscriber<? super T> sub) {
        return new SpanSubscriptionProvider<T>(beanFactory, sub, sub.currentContext(), scannable.name());
    }

    public static <T> Function<? super Publisher<T>, ? extends Publisher<T>> scopePassingSpanOperator(BeanFactory beanFactory) {
        return sourcePub -> {
            if (sourcePub instanceof ConnectableFlux || sourcePub instanceof GroupedFlux) {
                return sourcePub;
            }
            Function lift = Operators.lift((scannable, sub) -> {
                if (ReactorSleuth.contextRefreshed(beanFactory)) {
                    if (log.isTraceEnabled()) {
                        log.trace((Object)("Spring Context already refreshed. Creating a scope passing span subscriber with Reactor Context [" + sub.currentContext() + "] and name [" + scannable.name() + "]"));
                    }
                    return ReactorSleuth.scopePassingSpanSubscription(beanFactory, scannable, sub).get();
                }
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Spring Context is not yet refreshed, falling back to lazy span subscriber. Reactor Context is [" + sub.currentContext() + "] and name is [" + scannable.name() + "]"));
                }
                return new LazySpanSubscriber(ReactorSleuth.scopePassingSpanSubscription(beanFactory, scannable, sub));
            });
            return (Publisher)lift.apply(sourcePub);
        };
    }

    private static boolean contextRefreshed(BeanFactory beanFactory) {
        try {
            return ((ApplicationContextRefreshedListener)beanFactory.getBean(ApplicationContextRefreshedListener.class)).isRefreshed();
        }
        catch (NoSuchBeanDefinitionException e) {
            return false;
        }
    }

    private static <T> SpanSubscriptionProvider<T> scopePassingSpanSubscription(BeanFactory beanFactory, Scannable scannable, CoreSubscriber<? super T> sub) {
        return new SpanSubscriptionProvider<T>(beanFactory, (Subscriber)sub, sub.currentContext(), scannable.name(), (CoreSubscriber)sub){
            final /* synthetic */ CoreSubscriber val$sub;
            {
                this.val$sub = coreSubscriber;
                super(beanFactory, subscriber, context, name);
            }

            @Override
            SpanSubscription newCoreSubscriber(Tracing tracing) {
                return new ScopePassingSpanSubscriber(this.val$sub, this.val$sub != null ? this.val$sub.currentContext() : Context.empty(), tracing);
            }
        };
    }

    private ReactorSleuth() {
    }
}

