/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.opentracing;

import brave.Tracing;
import brave.opentracing.BraveTracer;
import io.opentracing.Tracer;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.sleuth.instrument.opentracing.SleuthOpentracingProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(value={"spring.sleuth.opentracing.enabled"}, matchIfMissing=true)
@ConditionalOnBean(value={Tracing.class})
@ConditionalOnClass(value={Tracer.class})
@EnableConfigurationProperties(value={SleuthOpentracingProperties.class})
public class OpentracingAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    Tracer sleuthOpenTracing(Tracing braveTracing) {
        return BraveTracer.create((Tracing)braveTracing);
    }
}

