/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.async;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.cloud.sleuth.instrument.async.TraceCallable;
import org.springframework.cloud.sleuth.instrument.async.TraceRunnable;
import org.springframework.cloud.sleuth.instrument.async.TraceableExecutorService;

public class TraceableScheduledExecutorService
extends TraceableExecutorService
implements ScheduledExecutorService {
    public TraceableScheduledExecutorService(BeanFactory beanFactory, ExecutorService delegate) {
        super(beanFactory, delegate);
    }

    private ScheduledExecutorService getScheduledExecutorService() {
        return (ScheduledExecutorService)this.delegate;
    }

    @Override
    public ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
        TraceRunnable r = new TraceRunnable(this.tracing(), this.spanNamer(), command);
        return this.getScheduledExecutorService().schedule(r, delay, unit);
    }

    @Override
    public <V> ScheduledFuture<V> schedule(Callable<V> callable, long delay, TimeUnit unit) {
        TraceCallable<V> c = new TraceCallable<V>(this.tracing(), this.spanNamer(), callable);
        return this.getScheduledExecutorService().schedule(c, delay, unit);
    }

    @Override
    public ScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
        TraceRunnable r = new TraceRunnable(this.tracing(), this.spanNamer(), command);
        return this.getScheduledExecutorService().scheduleAtFixedRate(r, initialDelay, period, unit);
    }

    @Override
    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
        TraceRunnable r = new TraceRunnable(this.tracing(), this.spanNamer(), command);
        return this.getScheduledExecutorService().scheduleWithFixedDelay(r, initialDelay, delay, unit);
    }
}

