/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.async;

import brave.ScopedSpan;
import brave.Tracer;
import brave.Tracing;
import brave.propagation.TraceContext;
import org.springframework.cloud.sleuth.SpanNamer;

public class TraceRunnable
implements Runnable {
    private static final String DEFAULT_SPAN_NAME = "async";
    private final Tracer tracer;
    private final Runnable delegate;
    private final TraceContext parent;
    private final String spanName;

    public TraceRunnable(Tracing tracing, SpanNamer spanNamer, Runnable delegate) {
        this(tracing, spanNamer, delegate, null);
    }

    public TraceRunnable(Tracing tracing, SpanNamer spanNamer, Runnable delegate, String name) {
        this.tracer = tracing.tracer();
        this.delegate = delegate;
        this.parent = tracing.currentTraceContext().get();
        this.spanName = name != null ? name : spanNamer.name(delegate, DEFAULT_SPAN_NAME);
    }

    @Override
    public void run() {
        ScopedSpan span = this.tracer.startScopedSpanWithParent(this.spanName, this.parent);
        try {
            this.delegate.run();
        }
        catch (Error | Exception e) {
            span.error(e);
            throw e;
        }
        finally {
            span.finish();
        }
    }
}

